#!/usr/bin/perl

=head1 DESCRIPTION

    20130412_images_queue.pl

=head1 DEPLOY

# approved by lena-san
# .migr
[
    {
        type => 'sql',
        webstop => "0",
        db => "ppc",
        when => 'before',
        time_estimate => "1 секунда",
        sql => ["CREATE TABLE `banner_images_process_queue` (
                      `imq_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                      `operator_uid` bigint(20) unsigned NOT NULL DEFAULT '0',
                      `ClientID` int(10) NOT NULL DEFAULT 0,
                      `url` varchar(1024) NOT NULL DEFAULT '',
                      `name` varchar(255) DEFAULT NULL,
                      `image_hash` varchar(22) CHARACTER SET latin1 DEFAULT NULL,
                      `status` enum('New','Process','Success','Failed') NOT NULL DEFAULT 'New',
                      `error` varchar(255) DEFAULT NULL,
                      `tries` tinyint(4) NOT NULL DEFAULT '0',
                      `create_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
                      `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                      `xls_id` int(10) unsigned,
                      PRIMARY KEY (`imq_id`),
                      KEY `st` (`status`),
                      KEY `url` (`url`),
                      KEY `xls_id` (`xls_id`),
                      KEY `operator_uid` (`operator_uid`),
                      KEY `ClientID` (`ClientID`)
                    ) ENGINE=InnoDB DEFAULT CHARSET=utf8" ,
                "CREATE TABLE `banner_images_process_queue_bid` (
                      `imq_id` bigint(20) unsigned NOT NULL default 0,
                      `bid` int(10) NOT NULL DEFAULT '0',
                      KEY `imq_id` (`imq_id`),
                      KEY `bid` (`bid`)
                    ) ENGINE=InnoDB DEFAULT CHARSET=utf8" ,
                "CREATE TABLE `banner_images_pool` (
                      `imp_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                      `ClientID` int(10) NOT NULL DEFAULT 0,
                      `name` varchar(255) DEFAULT NULL,
                      `image_hash` varchar(22) CHARACTER SET latin1 DEFAULT NULL,
                      `create_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
                      PRIMARY KEY (`imp_id`),
                      UNIQUE KEY `cl_im` (`ClientID`,`image_hash`),
                      KEY `im` (`image_hash`)
                    ) ENGINE=InnoDB DEFAULT CHARSET=utf8" ,
                ]
    },
    {
        type => 'script',
        when => 'after',
        time_estimate => '15 минут',
        comment => 'первоначальное заполнение banner_images_pool из banner_images'
    }
]

=cut

use strict;
use warnings;
use utf8;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

$log->out('start');

my $select_limit = 5_000;

my $rows_count = get_one_field_sql(PPC_HEAVY, "select count(*) from banner_images");

my $dbh = get_dbh(PPC_HEAVY);
$dbh->{mysql_use_result} = 1;

my $sth = exec_sql(PPC_HEAVY, "select u.ClientID, bim.image_hash, bim.name
                                 from banner_images bim
                           inner join banners b using (bid)
                           inner join campaigns c using (cid)
                           inner join users u on u.uid = c.uid");
$log->out("sql select executed");

my $processed = 0;
while (my $rows = $sth->fetchall_arrayref({}, $select_limit)) {
    last unless @$rows;
    do_mass_insert_sql(PPC, "insert ignore into banner_images_pool ( ClientID, image_hash, name, create_time ) values %s", 
                                                                   [ map { [$_->{ClientID}, $dbh->quote($_->{image_hash}), $dbh->quote($_->{name}), 'NOW()'] } @$rows ],
                                                                   { dont_quote => 1 });
    
    $processed += scalar(@$rows);

    $log->out("$processed images processed");
    last if $processed >= $rows_count; # обход бага DBD::Mysql (возможно после обновления это уже исправлено)
}
$sth->finish;

$log->out('finish');






















