#!/usr/bin/perl

=head1 DEPLOY

# approved by mirage
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "Зависит от параметра sleep. С умолчальной настройкой ожидается примерно 1 час.",
  comment => "Чтобы не перегружать базу, можно увеличить паузы: 
20130422_remove_lost_api_reports.pl --sleep 1/10 (спать 1 секунду каждые 10 запросов на удаление). 
По умолчанию спит 1 секунду каждые 100 запросов. 
В любой момент скрипт можно прибить и потом запустить заново, сделанная работа не потеряется.

### Прогресс
Количество найденных старых записей: 
cat /var/www/ppc.yandex.ru/protected/logs/20130422_remove_lost_api_reports.log.... |grep found
количество уже удаленных:
... |grep 'rm ' |wc -l 
  "
}

=cut

use strict;
use warnings;

use Data::Dumper;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

use Yandex::MongoDB;

use utf8;

$log->out('START');

my $sleep_str = "1/100";
GetOptions (
    'sleepe=s' => \$sleep_str,
);
die "sleep should be in <duration>/<frequency> format" unless $sleep_str =~ m!^(\d+)/(\d+)$! && $1 > 0 && $2 > 0;
my ($sleep_duration, $sleep_frequency) = ($1, $2);
$log->out("sleep $sleep_duration seconds every $sleep_frequency operations");

my $D = DateTime->new(
    year       => 2013,
    month      => 6,
    day        => 1,
    hour       => 0,
    minute     => 0,
    second     => 0,
    nanosecond => 0,
    time_zone  => 'local',
);

for my $collection (qw/api.wordstat api.stat api.forecast api.report/) {
    $log->out("processing collection $collection");
    my $mongodb = Yandex::MongoDB->new(db => $Settings::mongodb_name, collection => $collection.".files");
    my $cursor = $mongodb->{_collection}->find( { "uploadDate" => { '$lt' => $D } } );
    $log->out("$collection: found ".$cursor->count()." old files");
    #next;

    # для запуска чтений только со slave-серверов
    $cursor->slave_okay(1);
    my $cnt = 0;
    while (my $obj = $cursor->next()) {
        my $filename = $obj->{filename};
        if(!defined $filename){
            $log->out("undefined filename, md5: ".$obj->{md5});
            next;
        }
        $log->out("rm $filename");
        #$mongodb->{_collection}->remove( { filename => $filename } );
        $mongodb->gridfs_remove_data($collection, { filename => $filename });
        sleep($sleep_duration) if $cnt++ % $sleep_frequency == 0;
    }
    $log->out("removed $cnt files from collection $collection");
}

$log->out('FINISH');

