#!/usr/bin/perl


=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "примерно 1 сутки",
  comment => 'перед началом работы скрипта нужно скачать файл
scp ppcdev.yandex.ru:/home/n-boy/sid14-users.txt /tmp/sid14-users.txt
'
}

=cut

# отписываем лишние uid'ы от cid'а Директа в Паспорте

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/..";

use Settings;
use ScriptHelper;
use Yandex::DBTools;
use Yandex::Log;
use Yandex::Passport;
use RBACDirect;
use RBAC2::Extended;
use Yandex::Profile;
use Time::HiRes qw( gettimeofday tv_interval );
use utf8;
use open ':std' => ':utf8';

$log->out('start');

#Паспорт готов обрабатывать 50rps
#в один поток получается около 35rps, что нам подходит

my $rbac = new RBAC2::Extended(RBAC, RBAC_SLAVE);
$log->die("Can't connect to RBAC") if ! defined $rbac || ! $rbac->InitReq(1);

my $fpath = '/tmp/sid14-users.txt';
open(my $fh, $fpath) or $log->die("Can't open file $fpath");
my %process_uids = ();
my $progress_ind = 0;
my $total_processed = 0;
while (my $row = <$fh>) {
    chomp($row);
    my ($uid, $login) = split /\s+/, $row;
    next unless $uid && $uid =~ /^\d+$/ && $login;

    $process_uids{$uid} = $login;

    check_uids() if scalar(keys %process_uids) >= 100; #обрабатываем пачками по 100 логинов
}
check_uids() if scalar(keys %process_uids);

close($fh);
$log->out('finish');

sub check_uids {
    my $whois = rbac_multi_who_is($rbac, [keys %process_uids]);
    foreach my $uid (keys %$whois) {
        $total_processed++;
        next if ($whois->{$uid} && $whois->{$uid} ne 'empty');
        my $res = Yandex::Passport::admsubscribe_service($process_uids{$uid}, undef, 1);
        $log->out("$uid - $process_uids{$uid} - unsubscribe - " . ($res ? 'error' : 'ok'));
    }
    %process_uids = ();

    if ($total_processed - $progress_ind >= 10_000) {
        $log->out("Processed $total_processed out of ~4_500_000");
        $progress_ind = $total_processed;
    }
}