#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
[
  {
    type => 'sql',
    webstop => "0",
    db => "ppcdict",
    when => 'before',
    time_estimate => "1 sec",
    sql => [
      "CREATE TABLE IF NOT EXISTS inc_vcard_id (vcard_id int unsigned not null PRIMARY KEY  auto_increment);",
      "CREATE TABLE IF NOT EXISTS inc_org_details_id (org_details_id int unsigned not null PRIMARY KEY  auto_increment);",
      "CREATE TABLE IF NOT EXISTS inc_aid (aid int unsigned not null PRIMARY KEY  auto_increment);",
    ]
  },
{
    type => 'manual',
    when => 'instructions',
    instructions => 'см. описание',
    time_estimate => '5 минут до пакетов',
    text => q!

  1. Инициализируем таблицы достаточно большим id
  На один из  ppcback'ов выложить пакет yandex-direct-deploy-files релизной версии 
  Важно: выкладывать только этот один пакет, остальной Директ не обновлять.
  Выполнить скрипт, 2 секунды 
    
  perl /opt/ppc-data/deploy-files/deploy/20130510_shard_vcards.pl --inc

  Следующий пункт нужно делать сразу же после первого, пауза не больше 5 минут, если что - можно перезапустить

  2. Меняем offset'ы в таблицах, чтобы во время выкладки не было коллизий

  В базе ppc 
  lm ppcdata1 sql 'set global auto_increment_increment = 2; set global auto_increment_offset = 1;'

  В базе ppcdict
  lm ppcdict sql 'set global auto_increment_increment = 2; set global auto_increment_offset = 2;'

  на одном из ppcback
  direct-clus PERL apache-reload

  Для контроля:
  Запускаем
  LOG_TEE=1 perl -I/var/www/ppc.yandex.ru/protected /opt/ppc-data/deploy-files/deploy/20130510_shard_vcards.pl --check1
  Работает несколько минут. Если скрипт написал "OK", идем дальше. Если скрипт сообщил "FAIL": повторить запуск еще раз. 
  Если три запуска дают ошибки - сообщить релиз-менеджеру.
  Релиз-менеджеру же обратиться к eboguslavskaya@

  3. Пакеты
  
  Проверяем, что vcard_id, org_details_id, aid перестали выдаваться: 
  Запускаем
  LOG_TEE=1 perl -I/var/www/ppc.yandex.ru/protected /opt/ppc-data/deploy-files/deploy/20130510_shard_vcards.pl --check2
  Работает несколько минут. Если скрипт написал "OK", идем дальше. Если скрипт сообщил "FAIL": повторить запуск еще раз. 
  Если три запуска дают ошибки - сообщить релиз-менеджеру.
  Релиз-менеджеру же обратиться к eboguslavskaya@

  4. Меняем offset'ы обратно:
  
  на мастере ppcdata1
  lm ppcdata1 sql 'set global auto_increment_increment = 1; set global auto_increment_offset = 1;'

  на мастере ppcdict
  lm ppcdict sql 'set global auto_increment_increment = 1; set global auto_increment_offset = 1;'

  на одном из ppcback
  direct-clus PERL apache-reload


Если придется откатывать полностью выложенный релиз: 
Установить разные оффсеты на ppc и ppcdict (п. 2), 
откатить пакеты, 
вернуть offset=1 для ppc и ppcdict (п.4)

Повторная выкладка: 
в целом все надо повторить, но точную инструкцию надо будет составлять с учетом возникших проблем и того, насколько полностью все выложили в первый раз. 
    !,
},
]

=cut


use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use CheckShardMetabaseId;

use utf8;

my $INIT_INCREMENT = 0;
my $CHECK1 = 0;
my $CHECK2 = 0;

GetOptions("inc" => \$INIT_INCREMENT,
           "check1" => \$CHECK1,
           "check2" => \$CHECK2,
          );

my %tables = ('vcard_id'       => 'vcards',
              'org_details_id' => 'org_details',
              'aid'            => 'addresses',
             );

$log->out('START');

if ($INIT_INCREMENT) {
    my $OFFSET_VCARDS = 30_000;
    my $max_vcard_id = get_one_field_sql(PPC, "select max(vcard_id)+$OFFSET_VCARDS from vcards");
    $log->out("init vcards auto_increment with $max_vcard_id");
    do_sql(PPCDICT, "replace into inc_vcard_id values ($max_vcard_id)");


    my $OFFSET_ORG_DETAILS = 30_000;
    my $max_org_details_id = get_one_field_sql(PPC, "select max(org_details_id)+$OFFSET_ORG_DETAILS from org_details");
    $log->out("init org_details auto_increment with $max_org_details_id");
    do_sql(PPCDICT, "replace into inc_org_details_id values ($max_org_details_id)");

    my $OFFSET_ADDRESSES = 30_000;
    my $max_aid = get_one_field_sql(PPC, "select max(aid)+$OFFSET_ADDRESSES from addresses");
    $log->out("init addresses auto_increment with $max_aid");
    do_sql(PPCDICT, "replace into inc_aid values ($max_aid)");
    exit;
}
if ($CHECK1) {
    CheckShardMetabaseId::check(0, \%tables, $log);
    exit;
}
if ($CHECK2) {
    CheckShardMetabaseId::check(1, \%tables, $log);
    exit;
}


$log->out("FINISH");
exit;
