#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
{
    type => 'script',
    when => 'after',
    time_estimate => "~ 3 часа",
    comment => 'исправление ставок для сети, образовавшихся в результате загрузки xls с ошибками
        perl 20130520_fix_price_context.pl'
}

=cut

use strict;
use warnings;
use utf8;
use open ':std' => ':utf8';

use lib::abs '../protected';

use Settings;
use Yandex::DBTools;
use BannersCommon;
use Yandex::ListUtils;
use Currencies;
use ScriptHelper;

$log->out('start');

my $campaigns = get_bad_campaigns();
$log->out('got campaigns => ' . scalar keys %$campaigns);
while (my ($cid, $options) = each %$campaigns) {
    
    my $min_price = get_currency_constant($options->{currency} => 'MIN_PRICE');
    my @ids = map {/\d/ ? @{$options->{$_}} : ()} keys %$options;
    my $qty;
    if ($options->{is_different_places} || $options->{is_autobudget}) {
        $qty = do_update_table(PPC, 'bids',
                        {price_context => $min_price, modtime__dont_quote => 'modtime', statusBsSynced => 'No'},
                        where => {id => \@ids, price_context__gt => 50});
        $log->out("set campaign $cid min price = " . $min_price);                        
    } else {
        my $phrases = get_hash_sql(PPC,
                        ['SELECT b.id, IF(a.rank IS NULL OR a.rank > 0, 0, b.price * ? / 100)
                            FROM bids b LEFT JOIN bs_auction_stat a ON a.PhraseID = b.PhraseID AND a.pid = b.pid',
                            WHERE => {'b.id' => \@ids}], $options->{ContextPriceCoef});
        $qty = do_update_table(PPC, 'bids', {
            price_context__dont_quote => sql_case(PPC, id => $phrases, default => $min_price),
            modtime__dont_quote => 'modtime',
            statusBsSynced => 'No'
        }, where => {id => \@ids, price_context__gt => 50});
        $log->out("set campaign $cid price context with coeff " . $options->{ContextPriceCoef});
    }
    $log->out("$qty phrases affected ids: " . join ',', @ids)
}
$log->out('finish');


sub get_bad_campaigns {

    my %campaigns;     
    my $sth = exec_sql(PPC_HEAVY, 'SELECT id, bid, cid FROM bids WHERE price_context > 50');
    while (my ($id, $bid, $cid) = $sth->fetchrow_array()) {
        $campaigns{$cid} = {} unless exists $campaigns{$cid};
        push @{$campaigns{$cid}->{$bid} ||= []}, $id;  
    }
    
    foreach my $ids (chunks [keys %campaigns], 4000) {
        my $camps = get_all_sql(PPC,
                        ["SELECT c.cid, c.Autobudget = 'Yes' is_autobudget, co.strategy = 'different_places' is_different_places,
                            IFNULL(c.currency, 'YND_FIXED') currency, c.ContextPriceCoef
                            FROM campaigns c JOIN camp_options co ON c.cid = co.cid",
                            WHERE => {'c.cid' => $ids}]);
        foreach (@$camps) {
            $campaigns{$_->{cid}}->{is_autobudget} = $_->{is_autobudget};
            $campaigns{$_->{cid}}->{is_different_places} = $_->{is_different_places};
            $campaigns{$_->{cid}}->{currency} = $_->{currency};
            $campaigns{$_->{cid}}->{ContextPriceCoef} = $_->{ContextPriceCoef};
        } 
    }
    
    return \%campaigns;    
}
