#!/usr/bin/perl

=head1 DESCRIPTION

    20130521_fix_invalid_context_limit.pl

=head1 DEPLOY

# approved by zhur
# .migr
[
    
    {
        type => 'script',
        when => 'after',
        time_estimate => '50 секунд',
        comment => 'Корректируем некорректно отключенные показы в РСЯ при независимом управлении'
    }
]

=cut

use strict;
use warnings;
use utf8;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

$log->out('start');

my $camps = get_all_sql(PPC_HEAVY, "select c.cid, c.ContextLimit, c.ContextPriceCoef, c.dontShowYacontext, c.statusBsSynced, c.statusActive 
                                      from campaigns c inner join camp_options o using(cid) 
                                     where o.strategy = 'different_places' and c.dontShowYacontext = 'Yes'");
$log->out("sql select executed");
foreach my $camp (@$camps) {
    $log->out($camp);
    do_sql(PPC, ["update campaigns c join camp_options o on o.cid = c.cid
                     set c.ContextLimit = 0, 
                         c.ContextPriceCoef = 100, 
                         c.dontShowYacontext = 'No', 
                         c.statusBsSynced = 'No'",
                   where => {'c.cid' => $camp->{cid},
                             'o.strategy' => 'different_places',
                             'c.dontShowYacontext' => 'Yes' } ]);
}

# приводим все кампании с независимым управлением к стандартным ContextLimit = 0
# таких кампаний порядка 64_000, из них неархивных - 40_000
$camps = get_all_sql(PPC_HEAVY, "select c.cid, c.ContextLimit, c.ContextPriceCoef, c.dontShowYacontext, c.statusBsSynced, c.statusActive, c.archived
                                   from campaigns c inner join camp_options o using(cid) 
                                     where o.strategy = 'different_places' and c.dontShowYacontext = 'No' and c.ContextLimit <> 0");
$log->out("sql2 select executed");
while (my @camps_chunk = splice @$camps, 0, 1000) {
    foreach my $camp (@camps_chunk) {
        $log->out($camp);
    }
    do_sql(PPC, ["update campaigns c join camp_options o on o.cid = c.cid
                     set c.ContextLimit = 0, 
                         c.ContextPriceCoef = 100",
                   where => {'c.cid' => [ map { $_->{cid} } @camps_chunk ],
                             'o.strategy' => 'different_places',
                             'c.dontShowYacontext' => 'No',
                             'c.ContextLimit__ne' => 0 } ]);
    do_mass_insert_sql(PPC,"INSERT IGNORE INTO bs_resync_queue (cid) VALUES %s", [ map { [$_->{cid}] } grep { !$_->{archived} } @camps_chunk ]);
}

$log->out("finish");
