#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "1 час",
  comment => "заменяем ошибочные null-значения в campaigns и banners на умолчательные"
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

use utf8;

$log->out('START');

my $cids = get_one_column_sql(PPC_HEAVY, "SELECT cid FROM campaigns WHERE uid is null") || [];
$log->out("bad cids: ".join(',', @$cids));
if (@$cids > 10001) {
    $log->die("Error: unexpected number of bad campaigns: ".scalar(@$cids));
} elsif (@$cids) {
    do_sql(PPC, ["UPDATE campaigns SET uid = ifnull(uid, 0)",  where => {cid => $cids}]);
}

my $bids = get_one_column_sql(PPC_HEAVY, "SELECT bid FROM banners WHERE uid is null or cid is null or title is null or body is null or geoflag is null") || [];
$log->out("bad bids: ".join(',', @$bids));
if (@$bids > 1000) {
    $log->die("Error: unexpected number of bad banners: ".scalar(@$bids));
} elsif (@$bids) {
    do_sql(PPC, ["UPDATE banners SET uid = ifnull(uid, 0), cid=ifnull(cid, 0), title=ifnull(title, ''), body=ifnull(body, ''), geoflag=ifnull(geoflag, 0)",  where => {bid => $bids}]);
}

$log->out('FINISH');

