#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur 
# .migr
[
{
    type => 'manual',
    when => 'instructions',
    instructions => 'см. описание',
    time_estimate => '5 минут до пакетов, 10 минут после',
    text => q!

  1. Инициализируем таблицу shard_inc_cid достаточно большим cid'ом
  На один из  ppcback'ов выложить пакет yandex-direct-deploy-files релизной версии 
  Важно: выкладывать только этот один пакет, остальной Директ не обновлять.
  Выполнить скрипт, 2 секунды 
    
  perl -I/var/www/ppc.yandex.ru/protected /opt/ppc-data/deploy-files/deploy/20130524_shard_cid.pl --inc

  Следующий пункт нужно делать сразу же после первого, пауза не больше 5 минут, если что - можно перезапустить

  2. Меняем offset'ы в shard_inc_cid и campaigns, чтобы во время выкладки не было коллизий

  В базе ppc 
  lm ppcdata1 sql 'set global auto_increment_increment = 2; set global auto_increment_offset = 1;'

  В базе ppcdict
  lm ppcdict sql 'set global auto_increment_increment = 2; set global auto_increment_offset = 2;'

  на одном из ppcback
  direct-clus PERL apache-reload

  Для контроля: 
  в базе ppc 
  select max(cid) from campaigns;
  ждем минуты 2-3, затем смотрим, как распределяются новые cid'ы: 
  select cid % 2, count(*) from campaigns where cid > <max(cid) из предыдущего запроса> group by 1
  количество четных cid'ов должно остановиться и не расти. 
  Если продолжает расти через 5-6 минут -- это серьезная проблема, выкладку отменяем, думаем. 


  3. Пакеты
  
  Проверяем, что cid'ы в campaigns перестали выдаваться: 
  в базе ppc 
  select max(bid) from campaigns;
  ждем минуты 2-3, затем смотрим, как распределяются новые cid'ы: 
  select cid % 2, count(*) from campaigns where cid > <max(cid) из предыдущего запроса> group by 1
  количество нечетных cid'ов должно остановиться и не расти (четность, на которую смотрим, в п. 2 и 3 противоположная).
  (Сначала получали только нечетные cid из campaigns, теперь получаем только четные из shard_inc_cid)
  Если продолжает расти через 5-6 минут -- это серьезная проблема, думаем 
  (варианты: откатываемся; или пропускаем этот шаг, выполняем все дальше и потом ищем источник старых cid'ов). Лучше всего откатиться. 

  4. Меняем offset'ы обратно:
  
  на мастере ppcdata1
  lm ppcdata1 sql 'set global auto_increment_increment = 1; set global auto_increment_offset = 1;'

  на мастере ppcdict
  lm ppcdict sql 'set global auto_increment_increment = 1; set global auto_increment_offset = 1;'

  на одном из ppcback
  direct-clus PERL apache-reload

  5. Заполняем таблицу ppcdict::shard_inc_cid;
  скрипт, около 10 минут: 
  /var/www/ppc.yandex.ru/deploy/20130524_shard_cid.pl

Если придется откатывать полностью выложенный релиз: 
Установить разные оффсеты на ppc и ppcdict (п. 2), 
откатить пакеты, 
вернуть offset=1 для ppc и ppcdict (п.4)

Повторная выкладка: 
в целом все надо повторить, но точную инструкцию надо будет составлять с учетом возникших проблем и того, насколько полностью все выложили в первый раз. 
    !,
},
]

=cut


use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use Yandex::Retry;
use ScriptHelper;

use utf8;

my $INIT_INCREMENT = 0;
GetOptions("inc" => \$INIT_INCREMENT);

$log->out('START');

if ($INIT_INCREMENT) {
    # в среднем в середине дня выдается 10 новых cid в минуту
    my $OFFSET = 10_000;
    my $max_cid = get_one_field_sql(PPC, "select max(cid)+$OFFSET from campaigns");
    $log->out("init auto_increment with $max_cid");
    do_sql(PPCDICT, "replace into shard_inc_cid values ($max_cid,0)");
    $log->out("INIT FINISH");
    exit;
}


$log->out('campaigns -> shard_inc_cid');
my $campaigns = get_all_sql(PPC, "SELECT cid, users.ClientID FROM campaigns JOIN users USING(uid)");

$log->out("selected ".@$campaigns." records");

my $cnt = 0;
while (my @chunk = splice @$campaigns, 0, 10_000) {
  relaxed times => 2, sub {
    my @values = map {[$_->{cid}, $_->{ClientID}]} @chunk;
      do_mass_insert_sql(PPCDICT, 'REPLACE INTO shard_inc_cid (cid, ClientID) values %s', \@values);
    };
    $log->out("iteration ".$cnt++);    
}

$log->out("FINISH");
exit;
