#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
[
{
    type => 'script',
    when => 'after',
    time_estimate => "7 мин",
    comment => q! Заполняем таблицу shard_uid !,
},
]

=cut


use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use Yandex::Retry;
use ScriptHelper;
use Tools;

use utf8;
use List::MoreUtils qw/uniq/;

$log->out('START');

#users
$log->out('users -> shard_uid');
my $users = get_all_sql(PPC, "SELECT uid, ClientID FROM users WHERE ClientID!=0");

$log->out("selected ".@$users." records");

my $cnt = 0;
my $default_shard = get_new_available_shard(); 
while (my @chunk = splice @$users, 0, 10_000) {
    relaxed times => 2, sub {
        my @uid_values = map {[$_->{uid}, $_->{ClientID}]} @chunk;
        my @shard_values = map {[$_, $default_shard]} uniq map {$_->{ClientID}} @chunk;
        do_mass_insert_sql(PPCDICT, 'INSERT IGNORE INTO shard_uid (uid, ClientID) VALUES %s', \@uid_values);
        do_mass_insert_sql(PPCDICT, 'INSERT IGNORE INTO shard_client_id (ClientID, shard) VALUES %s', \@shard_values);
    };
    $log->out("iteration ".$cnt++);
}

$log->out("FINISH");
exit;
