#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
[
  {
    type => 'sql',
    webstop => "0",
    db => "ppcdict",
    when => 'before',
    time_estimate => "1 sec",
    sql => [
      "CREATE TABLE IF NOT EXISTS inc_phid (phid int unsigned not null PRIMARY KEY auto_increment);",
      "CREATE TABLE IF NOT EXISTS shard_inc_tag_id (tag_id int unsigned not null PRIMARY KEY auto_increment, ClientID int unsigned not null, index(ClientID));",
      "CREATE TABLE IF NOT EXISTS inc_ret_id (ret_id int unsigned not null PRIMARY KEY auto_increment);",
      "CREATE TABLE IF NOT EXISTS inc_ret_cond_id (ret_cond_id int unsigned not null PRIMARY KEY auto_increment);",
    ]
  },
  {
    type => 'sql',
    webstop => "0",
    db => "ppcdict",
    when => 'any',
    time_estimate => "1 sec",
    sql => "DROP TABLE shard_inc_mgid;"
  },
  {
    type => 'manual',
    when => 'instructions',
    instructions => 'см. описание',
    time_estimate => '5 минут до пакетов, 15 часов после',
    text => q!

  1. Инициализируем таблицы shard_inc_bid, inc_phid, shard_inc_tag_id, inc_ret_id, inc_ret_cond_id достаточно большим id.
  На один из  ppcback'ов выложить пакет yandex-direct-deploy-files релизной версии 
  Важно: выкладывать только этот один пакет, остальной Директ не обновлять.
  Выполнить скрипт, 2 секунды 
    
  perl -I/var/www/ppc.yandex.ru/protected /opt/ppc-data/deploy-files/deploy/20130527_shard_banners.pl --inc

  Следующий пункт нужно делать сразу же после первого, пауза не больше 5 минут, если что - можно перезапустить

  2. Меняем offset'ы в ppc и ppcdict, чтобы во время выкладки не было коллизий

  В базе ppc 
  lm ppcdata1 sql 'set global auto_increment_increment = 2; set global auto_increment_offset = 1;'

  В базе ppcdict
  lm ppcdict sql 'set global auto_increment_increment = 2; set global auto_increment_offset = 2;'

  на одном из ppcback
  direct-clus PERL apache-reload

  Для контроля:
  Запускаем
  LOG_TEE=1 perl -I/var/www/ppc.yandex.ru/protected /opt/ppc-data/deploy-files/deploy/20130527_shard_banners.pl --check1
  Работает несколько минут. Если скрипт написал "OK", идем дальше. Если скрипт сообщил "FAIL": повторить запуск еще раз. 
  Если три запуска дают ошибки - сообщить релиз-менеджеру.
  Релиз-менеджеру же обратиться к eboguslavskaya@

  3. Пакеты
  
  Проверяем, что id, bid, tag_id, ret_id и ret_cond_id перестали выдаваться: 
  Запускаем
  LOG_TEE=1 perl -I/var/www/ppc.yandex.ru/protected /opt/ppc-data/deploy-files/deploy/20130527_shard_banners.pl --check2
  Работает несколько минут. Если скрипт написал "OK", идем дальше. Если скрипт сообщил "FAIL": повторить запуск еще раз. 
  Если три запуска дают ошибки - сообщить релиз-менеджеру.
  Релиз-менеджеру же обратиться к eboguslavskaya@

  4. Меняем offset'ы обратно:
  
  на мастере ppcdata1
  lm ppcdata1 sql 'set global auto_increment_increment = 1; set global auto_increment_offset = 1;'

  на мастере ppcdict
  lm ppcdict sql 'set global auto_increment_increment = 1; set global auto_increment_offset = 1;'

  на одном из ppcback
  direct-clus PERL apache-reload

  5. Заполняем таблицу ppcdict::shard_inc_bid;
  скрипт, около 15 часов: 
  /var/www/ppc.yandex.ru/deploy/20130527_shard_banners.pl

Если придется откатывать полностью выложенный релиз: 
Установить разные оффсеты на ppc и ppcdict (п. 2), 
откатить пакеты, 
вернуть offset=1 для ppc и ppcdict (п.4)

Повторная выкладка: 
в целом все надо повторить, но точную инструкцию надо будет составлять с учетом возникших проблем и того, насколько полностью все выложили в первый раз. 
    !,
  },
]

=cut


use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use CheckShardMetabaseId;

use utf8;

my $INIT_INCREMENT = 0;
my $CHECK1 = 0;
my $CHECK2 = 0;

GetOptions("inc" => \$INIT_INCREMENT,
           "check1" => \$CHECK1,
           "check2" => \$CHECK2,
          );

my %tables = ('id'          => 'bids',
              'tag_id'      => 'tag_campaign_list',
              'ret_id'      => 'bids_retargeting',
              'ret_cond_id' => 'retargeting_conditions',
             );


$log->out('START');

if ($INIT_INCREMENT) {
    # в среднем в середине дня выдается 800 новых bid в минуту
    my $BID_OFFSET = 80_000;
    my $max_bid = get_one_field_sql(PPC, "select max(bid)+$BID_OFFSET from banners");
    $log->out("init shard_inc_bid auto_increment with $max_bid");
    do_sql(PPCDICT, "replace into shard_inc_bid values ($max_bid,0)");

    # в среднем в середине дня выдается 2000 новых id в минуту
    my $PHID_OFFSET = 500_000;
    my $max_phid = get_one_field_sql(PPC, "select max(id)+$PHID_OFFSET from bids");
    $log->out("init inc_phid auto_increment with $max_phid");
    do_sql(PPCDICT, "replace into inc_phid values ($max_phid)");

    # в среднем в середине дня выдается 8 новых tag_id в минуту
    my $TAG_ID_OFFSET = 30_000;
    my $max_tag_id = get_one_field_sql(PPC, "select max(tag_id)+$TAG_ID_OFFSET from tag_campaign_list");
    $log->out("init shard_inc_tag_id auto_increment with $max_tag_id");
    do_sql(PPCDICT, "replace into shard_inc_tag_id values ($max_tag_id,0)");

    # в среднем в середине дня выдается меньше 1 новых ret_cond_id в минуту
    my $RET_COND_ID_OFFSET = 30_000;
    my $max_ret_cond_id = get_one_field_sql(PPC, "select max(ret_cond_id)+$RET_COND_ID_OFFSET from retargeting_conditions");
    $log->out("init inc_ret_cond_id auto_increment with $max_ret_cond_id");
    do_sql(PPCDICT, "replace into inc_ret_cond_id values ($max_ret_cond_id)");

    # в среднем в середине дня выдается меньше 1 новых ret_id в минуту
    my $RET_ID_OFFSET = 30_000;
    my $max_ret_id = get_one_field_sql(PPC, "select max(ret_id)+$RET_ID_OFFSET from bids_retargeting");
    $log->out("init inc_ret_id auto_increment with $max_ret_id");
    do_sql(PPCDICT, "replace into inc_ret_id values ($max_ret_id)");

    $log->out("INIT FINISH");
    exit;
}
if ($CHECK1) {
    CheckShardMetabaseId::check(0, \%tables, $log);
    exit;
}
if ($CHECK2) {
    CheckShardMetabaseId::check(1, \%tables, $log);
    exit;
}

#----------------------------------
my $limit = 100_000;

my $cids = get_hashes_hash_sql(PPC, "SELECT cid, u.ClientID FROM campaigns JOIN users u USING(uid) WHERE u.ClientID!=0");
$log->out('got available cids');

$log->out('tag_campaign_list -> shard_inc_tag_id');

# Извлекаем все метки (их не много, всего полмиллиона).
my $tags = get_all_sql(PPC, "SELECT tag_id, cid FROM tag_campaign_list") || [];

my @values = map {[$_->{tag_id}, $cids->{$_->{cid}}->{ClientID}]} grep {$cids->{$_->{cid}}} @$tags;
do_mass_insert_sql(PPCDICT, 'REPLACE INTO shard_inc_tag_id (tag_id, ClientID) values %s', \@values);

$log->out("selected ".@$tags." tags");

$log->out('bids -> shard_inc_bid');

my $prev_bid = 0;
my $cnt = 0;
while (1) {
    # Извлекаем очередную партию баннеров.
    my $bids = get_all_sql(PPC, "SELECT bid, cid FROM banners WHERE bid > ? ORDER BY bid LIMIT ?", $prev_bid, $limit) || [];
    last unless @$bids;
    $prev_bid = $bids->[-1]->{bid};
    
    my @values = map {[$_->{bid}, $cids->{$_->{cid}}->{ClientID}]} grep {$cids->{$_->{cid}}} @$bids;
    do_mass_insert_sql(PPCDICT, 'REPLACE INTO shard_inc_bid (bid, ClientID) values %s', \@values);

    $log->out(sprintf("selected %d bids last bid in the group = %d", scalar(@$bids), $prev_bid));
    $log->out("iteration ".$cnt++);
}


$log->out("FINISH");
exit;
#----------------------------------

