#!/usr/bin/perl

=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "10 секунд",
  comment => "Сбрасываем statusEasy у всех, у кого его не должно быть (суперы, агентства, менеджеры итп)"
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use RBAC2::Extended;
use RBACDirect;

use utf8;

$log->out('START');

my $rbac = eval { get_singleton RBAC2::Extended() };
if ($@ || ! defined $rbac) {
    $log->die("failed to get rbac instance");
}
$rbac->InitReq(1) or $log->die("rbac InitReq failed");

$log->out("get all agencies");
my $ag_uids = rbac_get_all_agencies($rbac);
$log->out("selected ".(scalar @$ag_uids)." agency uids");
my $easy_agencies = get_one_column_sql(PPC, ["select u.uid from users u join users_options uo using(uid)", where => { 
    'u.uid' => $ag_uids,
    statusEasy => 'Yes',
}]) || [];
$log->out("selected ".(scalar @$easy_agencies)." easy agencies: ");
$log->out($easy_agencies);
do_update_table(PPC, 'users_options', { statusEasy => 'No' }, where => { uid => $easy_agencies });

$log->out("rbac get staff");
my $staff = rbac_get_staff($rbac);
my @uids = map { @$_ } values %$staff;
$log->out((scalar @uids)." uids to check");
my $easy = get_one_column_sql(PPC, ["select u.uid from users u join users_options uo using(uid)", where => {
    'u.uid' => \@uids,
    'statusEasy' => 'Yes',
}]) || [];
$log->out('selected '.( scalar @$easy ).' easy special users');
$log->out($easy);
do_update_table(PPC, 'users_options', { statusEasy => 'No' }, where => { uid => $easy });

$log->out('FINISH');

