#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
[
{
    type => 'script',
    when => 'after',
    time_estimate => "2 мин",
    comment => q! Создаем ClientID для служебных пользователей !,
},
]

=cut


use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use Tools;
use RBACDirect;
use RBAC2::Extended;
use Client;
use User;

use utf8;

$log->out('START');


 my $rbac = new RBAC2::Extended(RBAC, RBAC_SLAVE);
die "Can't connect to RBAC" if ! defined $rbac || ! $rbac->InitReq(1);

my $staff = rbac_get_staff($rbac);
die if ref($staff) ne 'HASH' || ! %$staff;

my %uids;
for my $role (keys %$staff) {
    $uids{$_} = 1 for @{$staff->{$role}};
}
$log->out('Get staff without ClientID');
my $users = get_all_sql(PPC, ["select uid, login, FIO, phone, email from users", where => {"uid" => [keys %uids], 'ClientID' => 0}]);
my $default_country = $geo_regions::RUS; # Россия
my $default_currency = 'YND_FIXED'; # Старая валюта

$log->out('Create client in balance');
foreach my $user (@$users) {
    $user->{initial_country} = $default_country;
    $user->{initial_currency} = $default_currency;
    my $client_id = create_client_in_balance($user->{uid}, $user->{uid}, %$user);
    create_update_user( $user->{uid}, { ClientID => $client_id } );
    $log->out(sprintf("create ClientID to uid: %s; login: %s; ClientID: %s", $user->{uid}, $user->{login}, $client_id));
}
$log->out(sprintf("Created ClientIDs for %d users", scalar(@$users)));
$log->out("FINISH");
exit;
