#!/usr/bin/perl

=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "30 минут",
  comment => '
  Перед началом работы 
  scp root@ppcdev.yandex.ru:/home/icenine/20130611_banner_images_avatars.txt /tmp/20130611_banner_images_avatars.txt
  Переливаем картинки в Аватарницу (только те, что есть в модерации, но нет в Аватарнице)',
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use BannerImages;
use Getopt::Long;
use Time::HiRes qw/sleep/;
use Yandex::Avatars;

use utf8;

$log->out('START');

my $cnt = 0;

open my $F, '<', '/tmp/20130611_banner_images_avatars.txt' or $log->die("/tmp/20130611_banner_images_avatars.txt : $!");

my @images = map { chomp ; $_ } <$F>;

for my $image_hash (@images) {
    if (get_one_field_sql(PPC, "select 1 from banner_images_formats where image_hash = ?", $image_hash)) {
        $log->out("$image_hash - alredy in avatars");
        next;
    }
    $cnt++;
    my $data = BannerImages::_im_data_by_hash($image_hash);
    unless ($data) {
        $log->out("missing data for image '$image_hash'");
        next;
    }
    $log->out("$cnt) $image_hash");
    BannerImages::save_image_avatars({ md5 => $image_hash, img => $data });
}

$log->out("$cnt images uploaded");

$log->out('FINISH');

