#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
[{
  type => 'sql',
  webstop => "0",
  db => "ppcdict",
  when => 'before',
  time_estimate => "1 sec",
  sql => "CREATE TABLE `pages` (
                `PageID` int(11) NOT NULL DEFAULT '0',
                `domain` text NOT NULL,
                `TargetType` int(11) NOT NULL DEFAULT '0',
                `descr` text,
                `name` varchar(200) NOT NULL DEFAULT 'не определена',
                `group_nick` varchar(200) NOT NULL DEFAULT 'nd',
                `sorting` int(11) NOT NULL DEFAULT '9',
                PRIMARY KEY (`PageID`),
                KEY `group_nick` (`group_nick`(20))
              ) ENGINE=InnoDB DEFAULT CHARSET=utf8"
},
{
    type => 'script',
    when => 'after',
    time_estimate => '40 сек',
    comment => 'добавления индекса по pages.group_nick во всех шардах ppcstat, и заполнение ppcdict.pages'
},
{
    type => 'script',
    when => 'after',
    time_estimate => "порядка 1 дня",
    comment => "",
    script => "/var/www/ppc.yandex.ru/protected/ppcCampGetGoals.pl --force --days=180 --skip-exists --no-count"
}]

=cut

use strict;
use warnings;

use utf8;
use open ':std' => ':utf8';

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

foreach my $ppcstat_db (sort @{get_db_childs('ppcstat')}) {
    $log->out("$ppcstat_db start");
    my $dbh = connect_db(get_db_config($ppcstat_db));
    unless (get_one_field_sql($dbh, qq/SELECT COUNT(1) IndexIsThere 
                                         FROM INFORMATION_SCHEMA.STATISTICS
                                        WHERE table_schema=DATABASE() AND table_name='pages' AND index_name='group_nick'/)) {
        do_sql($dbh, qq/CREATE INDEX group_nick ON pages (group_nick(20))/);
        $log->out("$ppcstat_db index created")
    } else {
        $log->out("$ppcstat_db index already exists");
    }
    disconnect_db($dbh);
    $log->out("$ppcstat_db finish");
}

my $ppcstat_db = (sort @{get_db_childs('ppcstat')})[0];
my $dbh = connect_db(get_db_config($ppcstat_db));
my @fields = qw/PageID domain TargetType descr name group_nick sorting/;
$log->out("select all pages from ppcstat.pages");
my $pages = get_all_sql($dbh, "select " . join(', ', @fields) ." from pages");
$log->out("inserting " . scalar(@$pages) ." into ppcdict.pages");
do_mass_insert_sql(PPCDICT, "REPLACE LOW_PRIORITY INTO pages ( " . join(', ', @fields) ." ) VALUES %s", [map { my $p = $_; [map { $p->{$_} } @fields] } @$pages]);
$log->out("finish");