#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
[
{
  type => 'sql',
  webstop => "0",
  db => "ppcdict",
  when => 'before',
  time_estimate => "1 sec",
  sql => "
    CREATE TABLE `products` (
      `ProductID` int(10) NOT NULL,
      `product_name` varchar(128) DEFAULT NULL,
      `theme_id` int(10) NOT NULL DEFAULT '0',
      `type` enum('text','mcb','socdem','anticontext','geo','mcb_pkg','mcb_regional') NOT NULL DEFAULT 'text',
      `Price` decimal(16,6) DEFAULT NULL,
      `currency` enum('RUB','UAH','BYR','KZT','USD','EUR','YND','YND_FIXED','TRY','CHF') DEFAULT 'YND_FIXED',
      `NDS` tinyint(1) DEFAULT NULL,
      `UnitName` varchar(32) DEFAULT NULL,
      `EngineID` int(10) DEFAULT NULL,
      `Rate` int(10) DEFAULT NULL,
      `daily_shows` int(10) DEFAULT NULL,
      `packet_size` int(10) DEFAULT NULL,
      PRIMARY KEY (`ProductID`,`theme_id`,`type`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8
  ",
},
{
  type => 'script',
  when => 'after',
  time_estimate => "1 секунда",
  comment => "переносим таблицу products в ppcdict"
},
{
  type => 'sql',
  webstop => "0",
  db => "ppc",
  when => 'after',
  time_estimate => "1 sec",
  sql => "rename table products to products_old",
},
]

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;
local $Yandex::DBShards::STRICT_SHARD_DBNAMES = 0;

use utf8;

$log->out('START');
      
do_insert_select_sql(PPC, "insert into products 
          ( ProductID, product_name, theme_id, type, Price, currency, NDS, UnitName, EngineID, Rate, daily_shows, packet_size ) values %s",
    "select ProductID, product_name, theme_id, type, Price, currency, NDS, UnitName, EngineID, Rate, daily_shows, packet_size from products",
    dbw => PPCDICT);

$log->out('FINISH');

