#!/usr/bin/perl

=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "1-2 часа",
  comment => 'Переливаем все картинки в Аватарницу',
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use BannerImages;
use Getopt::Long;
use Time::HiRes qw/sleep/;
use Yandex::Avatars;
use Parallel::ForkManager;

use utf8;

my $PARALLEL = 5;
GetOptions(
    "parallel|p=i",
);

$log->out('START');

my $pm = new Parallel::ForkManager($PARALLEL);
my $images = get_one_column_sql(PPC, "select image_hash from banner_images_formats");

for my $image (@$images) {
    my $pid = $pm->start and next;
    $log->msg_prefix("[$$]");
    my $data = avatars_get($image, 'orig');
    unless ($data) {
        $log->out("failed to fetch image '$image'");
        $pm->finish;
        next;
    }
    $log->out("fetched image $image");
    avatars_put($image, $data);
    $log->out("sent image $image");
    $pm->finish;
}
$pm->wait_all_children();

$log->out('FINISH');

