#!/usr/bin/perl

=head1 DEPLOY

# approved by lena-san
# .migr
[
    {
        type => 'script',
        when => 'after',
        time_estimate => '4.5 часа',
        comment => q[
        
            Исправление неправильно проставленных рубрик у баннеров
                        
            можно запускать с коэффициентом для вычисления паузы между итерациями
            (что бы реплики не отставали)
        
            20130625_fix_banners_yacontextCategories.pl --sleep-coeff=1
            если реплики отстают, можно увеличить --sleep-coeff
        ],
    }
]

=cut

use strict;
use warnings;

use utf8;
use open ':std' => ':utf8';

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Getopt::Long;
use Yandex::Retry;
use Settings;
use Yandex::DBTools;
use ScriptHelper;
    
use constant PIDS_PER_ITERATION => 10000;

my $sleep_coeff = 1;
GetOptions(
    'sleep-coeff=i' => \$sleep_coeff,
);

$log->out('start');
while (my $banners = get_next_banners()) {
     relaxed times => $sleep_coeff, sub {
        do_update_table(PPC, 'banners', {
            LastChange__dont_quote => 'LastChange',
            yacontextCategories__dont_quote => sql_case(PPC, bid => $banners)
        }, where => {bid => [keys %$banners]});
    };
}
$log->out('finish'); 

{
my ($max_bid, $offset);
sub get_next_banners {
    
    $max_bid = get_one_field_sql(PPC, 'SELECT MAX(bid) FROM banners') unless defined $max_bid;
    $offset = 0 unless defined $offset;
    
    my $banners = [];
    while (!@$banners && $offset <= $max_bid) {
        $banners = get_all_sql(PPC,
            "SELECT b.bid, p.yacontextCategories FROM banners b JOIN phrases p USING(bid)
                WHERE b.bid BETWEEN ? AND ? AND IFNULL(p.yacontextCategories, '') <>  IFNULL(b.yacontextCategories, '')",
            $offset, $offset + PIDS_PER_ITERATION);
        $offset += PIDS_PER_ITERATION + 1;
    }
    
    $log->out(sprintf "got %d banners; processed %d/%d", scalar(@$banners), $offset, $max_bid); 
    
    return @$banners ? {map {($_->{bid} => $_->{yacontextCategories})} @$banners} : undef;
}
}
