#!/usr/bin/perl

=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "меньше минуты"
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use BannerImages;
use Time::HiRes qw/sleep/;
use Yandex::Avatars;

use utf8;

$log->out('START');

my $images = get_one_column_sql(PPC, "select image_hash from banner_images_process_queue where status = 'Success' and update_time >= '2013-06-26 12:48'");
for my $image_hash (@$images) {
    my $data_db = BannerImages::_im_data_by_hash($image_hash);
    if ($data_db) {
        $log->out("$image_hash - alredy in DB");
        next;
    }
    my $data_avatar = Yandex::Avatars::avatars_get($image_hash, 'orig');
    unless ($data_avatar) {
        $log->out("missing avatar data for image '$image_hash'");
        next;
    }

    my $check = BannerImages::banner_check_image($data_avatar);
    if ($check->{error}) {
        $log->out("incorrect avatar data for image '$image_hash'");
        next;
    }
    BannerImages::banner_save_image($check, 0, type => 'banner_images');
    $log->out("$image_hash - saved to DB");
}

$log->out('FINISH');

