#!/usr/bin/perl

use my_inc "..";


=head1 DEPLOY

# approved by zhur
# .migr
[
{
  type => 'manual',
  when => 'after',
  time_estimate => "30 сек",
  text => q[
    остановить старый экземпляр скрипта metrica_notify.pl, чтоб не перетереть результаты миграции 
    сделать kill процессу с именем metrica_notify.pl

    pkill -f 'metrica_notify.pl'
  ]
},
{
  type => 'script',
  when => 'after',
  time_estimate => "1 сек",
  comment => "меняет id события с которого надо начинать тянуть данные мониторинга метрики 
  (хотим перезатянуть все события с 26.05.2013)"
}
]
=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper get_file_lock => undef;
use Property;

use utf8;

$log->out('START');

my $last_id = 89505538;
my $prop_name = 'METRICA_NOTIFY_LAST_ID';
my $last_metrica_id_property = Property->new($prop_name);

my $prev_last_id = $last_metrica_id_property->get();
$last_metrica_id_property->set($last_id);

$log->out("Property $prop_name changed from $prev_last_id to $last_id");

$log->out('FINISH');

