#!/usr/bin/perl

use my_inc "..";


=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'manual',
  when => 'before',
  time_estimate => 'минута',
  text => q[
    1. На один из  ppcback'ов выложить пакет yandex-direct-deploy-files релизной версии
       Важно: выкладывать только этот один пакет, остальной Директ не обновлять.
    2. На том же ppcback'е запустить скрипт, который должен успешно завершиться и ничего не вывести на консоль:
         /opt/ppc-data/deploy-files/deploy/20130703_multicurrency-add-ppcstat-currency_rates.pl
  ],
}


=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

use utf8;

$log->out('START');

for my $db (sort @{get_db_childs('ppcstat')}) {
    $log->out("Creating currency_rates in $db");
    my $res = eval {
        do_sql($db, q/
          CREATE TABLE ppcstat_data.currency_rates (
              `currency` char(3) NOT NULL,
              `date` date NOT NULL,
              `rate` decimal(24,16) NOT NULL,
              PRIMARY KEY (`currency`,`date`)
          ) ENGINE=MyISAM DEFAULT CHARSET=utf8
        /);
        return 1;
    };
    if (!$res) {
        $log->out("ERROR creating table in $db: $@");
    }
}

$log->out('FINISH');
