#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "30-80 минут",
  comment => "Заполняем geo_id в визитках с geo_id=0, ставим баннеры на переотправку в БК"
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

use GeoTools qw/get_geoid_by_cityname/;
use Yandex::Retry;

use utf8;

$log->out('START');

my $quote_dbh = get_dbh(PPCDICT);
my $sth = exec_sql(PPC_HEAVY, q/SELECT vcard_id, city FROM vcards WHERE geo_id = 0/);

while (my ($vcard_id, $city) = $sth->fetchrow_array) {
    # Пытаемся вычислить geo_id
    my $geo_id = get_geoid_by_cityname($quote_dbh, $city);
    # Определить не получилось
    next unless $geo_id;

    my $banners_to_resync = get_all_sql( PPC, [
            'SELECT cid, bid FROM banners b',
            WHERE => {
                vcard_id => $vcard_id,
                'b.statusBsSynced' => 'Yes',
            },
        ]
    );

    relaxed times => 3, sub {
        do_in_transaction {
            do_update_table( PPC, 'vcards',
                { geo_id => $geo_id },
                where => { vcard_id => $vcard_id }
            );

            if ( @$banners_to_resync ) {
                do_mass_insert_sql( PPC,
                    'INSERT IGNORE INTO bs_resync_queue (cid, bid) VALUES %s',
                    [ map {[ $_->{cid}, $_->{bid} ]} @$banners_to_resync ],
                );
            }
        };
        $log->out("updated vcard #$vcard_id: set geo_id = $geo_id");
        $log->out("banners ro resyns: ".join(", ", map {$_->{bid}} @$banners_to_resync)) if @$banners_to_resync;
    };
}
$sth->finish();

$log->out('FINISH');

