#!/usr/bin/perl

use my_inc "..";


=head1 DEPLOY

# approved by mirage
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "15s",
  comment => "для агентства admitadGmbH переотправить фразы, чтобы в БК ушли их phrase_id для подстановки в URL (DIRECT-23648)"
}
=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

use utf8;

$log->out('START');

my $broken_cids = get_one_column_sql(PPC, ["select cid from campaigns", where => {AgencyID => 1621799}]) || [];

$log->out('Number of cids: '.(scalar @$broken_cids));

foreach my $cid(@$broken_cids) {
    my $phrases = get_one_column_sql(PPC, ["select pid from phrases", where => {cid => $cid}]) || [];
    if (@$phrases) {
        do_mass_insert_sql(PPC, 'insert into bs_resync_queue (cid, pid) values %s', [map {[$cid, $_]} @$phrases]);
    }
    $log->out('Queued to resync: '.$cid);
}

$log->out('FINISH');