#!/usr/bin/perl

use my_inc "..";


=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "2 min",
  comment => "Возвращаем удаленных (скриптом protected/one-shot/delete_users_wo_ClientID.pl) по ошибке пользователей."
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use Yandex::HashUtils;
use ScriptHelper;
use User;

use utf8;

$log->out('START');


my %users = (24118040 => {statusEasy => 'Yes'},
			 48252685 => {statusEasy => 'Yes', email=>'ed__ik@mail.ru'},
			 197475181=> {statusEasy => 'No'},
			 15141701 => {statusEasy => 'No'},
			 22453844 => {statusEasy => 'No'},
			 38319213 => {statusEasy => 'No'},
	        );

foreach my $uid (keys %users) {
	create_update_user($uid, hash_merge ({UID=>$uid}, $users{$uid}));
	$log->out("created users $uid");
}

$log->out('FINISH');

