#!/usr/bin/perl

use my_inc "..";


=head1 DEPLOY

# approved by zhur
# .migr
[
  {
  type => 'sql',
  webstop => "0",
  db => "ppcdict",
  when => 'before',
  time_estimate => "1 секунда",
  sql => "CREATE TABLE IF NOT EXISTS inc_mw_id (mw_id int unsigned not null PRIMARY KEY auto_increment);",
  },
  {
    type => 'manual',
    when => 'instructions',
    instructions => 'см. описание',
    time_estimate => '5 минут до пакетов, 5 минут после',
    text => q!

  1. Инициализируем таблицы inc_mw_id, shard_inc_mbid достаточно большим id.
  На один из  ppcback'ов выложить пакет yandex-direct-deploy-files релизной версии 
  Важно: выкладывать только этот один пакет, остальной Директ не обновлять.
  Выполнить скрипт, 2 секунды 
    
  perl -I/var/www/ppc.yandex.ru/protected/ /opt/ppc-data/deploy-files/deploy/20130805_shard_minus_words.pl --inc

  Следующий пункт нужно делать сразу же после первого, пауза не больше 5 минут, если что - можно перезапустить

  2. Меняем offset'ы в ppc и ppcdict, чтобы во время выкладки не было коллизий

  В базе ppc 
  lm ppcdata1 sql 'set global auto_increment_increment = 2; set global auto_increment_offset = 1;'

  В базе ppcdict
  lm ppcdict sql 'set global auto_increment_increment = 2; set global auto_increment_offset = 2;'

  на одном из ppcback
  direct-clus PERL apache-reload

  Для контроля:
  Запускаем
  LOG_TEE=1 perl /opt/ppc-data/deploy-files/deploy/20130805_shard_minus_words.pl --check1
  Работает несколько минут. Если скрипт написал "OK", идем дальше. Если скрипт сообщил "FAIL": повторить запуск еще раз. 
  Если три запуска дают ошибки - сообщить релиз-менеджеру.
  Релиз-менеджеру же обратиться к eboguslavskaya@

  3. Пакеты
  
  Проверяем id:
  Запускаем
  LOG_TEE=1 perl /opt/ppc-data/deploy-files/deploy/20130805_shard_minus_words.pl --check2
  Работает несколько минут. Если скрипт написал "OK", идем дальше. Если скрипт сообщил "FAIL": повторить запуск еще раз. 
  Если три запуска дают ошибки - сообщить релиз-менеджеру.
  Релиз-менеджеру же обратиться к eboguslavskaya@

  4. Меняем offset'ы обратно:
  
  на мастере ppcdata1
  lm ppcdata1 sql 'set global auto_increment_increment = 1; set global auto_increment_offset = 1;'

  на мастере ppcdict
  lm ppcdict sql 'set global auto_increment_increment = 1; set global auto_increment_offset = 1;'

  на одном из ppcback
  direct-clus PERL apache-reload

Если придется откатывать полностью выложенный релиз: 
Установить разные оффсеты на ppc и ppcdict (п. 2), 
откатить пакеты, 
вернуть offset=1 для ppc и ppcdict (п.4)

Повторная выкладка: 
в целом все надо повторить, но точную инструкцию надо будет составлять с учетом возникших проблем и того, насколько полностью все выложили в первый раз. 
    !,
}
]
=cut


use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use CheckShardMetabaseId;

use utf8;

$Yandex::DBShards::STRICT_SHARD_DBNAMES = 0;
my $INIT_INCREMENT = 0;
my $CHECK1 = 0;
my $CHECK2 = 0;

GetOptions("inc" => \$INIT_INCREMENT,
           "check1" => \$CHECK1,
           "check2" => \$CHECK2,
          );

my %tables = ('mw_id'            => 'minus_words',
              'mbid'             => 'media_banners',
             );


my $OFFSET = 300_000;

if ($INIT_INCREMENT) {
    $log->out('INIT START');
    my $max_mw_id = get_one_field_sql(PPC, "select max(mw_id)+$OFFSET from minus_words");
    $log->out("init inc_mw_id auto_increment with $max_mw_id");
    do_sql(PPCDICT, "replace into inc_mw_id values ($max_mw_id)");

    my $max_mbid = get_one_field_sql(PPC, "select max(mbid)+$OFFSET from media_banners") || 0;
    $log->out("init shard_inc_mbid auto_increment with $max_mbid");
    do_sql(PPCDICT, "replace into shard_inc_mbid (mbid, ClientID) values ($max_mbid, 0)");

    $log->out("INIT FINISH");
    exit;
}
if ($CHECK1) {
    CheckShardMetabaseId::check(0, \%tables, $log);
    exit;
}
if ($CHECK2) {
    CheckShardMetabaseId::check(1, \%tables, $log);
    exit;
}

exit;
