#!/usr/bin/perl

use my_inc "..";


=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => 'несколько секунд',
  comment => 'Прописываем клиенту ooostroymart-ru страну в Балансе',
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

use Client;
use Primitives;
use PrimitivesIds;
use geo_regions;

use utf8;

my $login = 'ooostroymart-ru';
my $country = $geo_regions::RUS;
my $operator_uid = 1;

$log->out('START');

my $uid = get_uid_by_login2($login);
my $client_id = get_clientid(uid => $uid);

create_update_client({client_data => {ClientID => $client_id, country_region_id => $country}});
my $error = update_client_id($operator_uid, $client_id, {REGION_ID => $country});
if ($error) {
    $log->out('update_client_id вернул ошибку');
}

$log->out('FINISH');
