#!/usr/bin/perl

use my_inc "..";


=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "2 min",
  comment => "Возвращаем удаленных (скриптом protected/one-shot/delete_users_wo_ClientID.pl) по ошибке пользователей."
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use Yandex::HashUtils;
use ScriptHelper;
use User;
use Campaign;
use E;

use utf8;

$log->out('START');

# Создаем клиентов, которые в момент запуска скрипта удаления пользователей внезапно пришли и создали кампании. Тут список только пользователей с неоплаченными кампаниями.
# С оплаченными кампаниям пользователи были созданы "по горячим следам".
my %users = (103344095 => {statusEasy => 'Yes'},
	     58727339  => {statusEasy => 'No'},
	     94945284  => {statusEasy => 'No'},
	     26522915  => {statusEasy => 'Yes'},
	     26142444  => {statusEasy => 'No'}, 
	     73866359  => {statusEasy => 'Yes'},
	     25187894  => {statusEasy => 'No'},
            );

foreach my $uid (keys %users) {
	create_update_user($uid, hash_merge ({UID=>$uid}, $users{$uid}));
	$log->out("created user: $uid");
}

# Удаляем кампании, которые не имеют записи в users, и которые Campaign::is_camp_deletable()
my $cids = get_all_sql(PPC, "SELECT cid, c.uid FROM campaigns c LEFT JOIN users u ON u.uid=c.uid WHERE u.uid IS NULL AND c.uid>0");

foreach (@$cids) {
    del_camp(PPC, $rbac, $_->{cid}, $_->{uid}, ignore_rbac_errors => 1, silent_rbac_errors => 1, force => 1);
    $log->out(sprintf("camp %s was deleted (non exists user %s)", $_->{cid}, $_->{uid}));
}

# Удаляем кампании, у которых uid = 0 (при условии, что на них нет денег и они не были в БК)
my $deleted = do_delete_from_table(PPC, 'campaigns', where=>{uid => 0, sum => 0, sum_to_pay => 0, sum_last => 0, OrderID => 0});
$log->out(sprintf("deleted %d campaigns with uid=0 (all of them were deletable)", $deleted));

$log->out('FINISH');

