#!/usr/bin/perl

use my_inc "..";


=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => 'несколько часов',
  comment => 'удаляем пустые группы',
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use Tag;

use utf8;

$log->out('START');

my ($min_pid, $max_pid) = get_one_line_array_sql(PPC_HEAVY, "select min(pid), max(pid) from phrases");
my $step = 1_000_000;
my $del_groups_qty = 0;
while ($min_pid <= $max_pid) {
    my $empty_groups = get_one_column_sql(PPC_HEAVY, "select p.pid from phrases p left join banners b using (pid) where b.pid is null and p.pid between ? and ? and p.cid <> 0", $min_pid, $min_pid + $step);

    #код из Models:AdGroup::delete_groups
    if ($empty_groups && @$empty_groups) {
        $log->out("Delete groups with pid: " . join ',', @$empty_groups);
        foreach my $tbl (qw/phrases tag_group bids bids_retargeting/) {
            my $tbl_data = get_all_sql(PPC, ["SELECT * FROM $tbl",
                                             where => {pid => $empty_groups}]);
            $log->out({table => $tbl, data_chunk => $tbl_data});
        }
        do_delete_from_table(PPC, 'phrases', where => {pid => $empty_groups});
        # удаляем метки для объявлений
        Tag::delete_group_tags($empty_groups);
        do_delete_from_table(PPC, 'bids', where => {pid => $empty_groups});
        do_delete_from_table(PPC, 'bids_retargeting', where => {pid => $empty_groups});
        $del_groups_qty += scalar(@$empty_groups);
    }
    $min_pid += $step + 1;
    $log->out("pids count: processed $min_pid out of $max_pid / deleted $del_groups_qty");
}

$log->out('FINISH');
