#!/usr/bin/perl

use my_inc "..";


=head1 DEPLOY

# approved by lena-san
# .migr
[
    {
        type => 'sql',
        webstop => "0",
        db => "ppc",
        when => 'before',
        time_estimate => "1 sec",
        sql => "    
            CREATE TABLE `group_params` (
              `pid` int(10) unsigned NOT NULL,
              `has_phraseid_href` tinyint NOT NULL DEFAULT 0,
              PRIMARY KEY (`pid`)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8
        "
    },
    {
      type => 'script',
      when => 'after',
      time_estimate => "1 час на devtest",
      comment => "пересчет параметризированных баннеров у группы
      
         можно запускать с коэффициентом для вычисления паузы между записями в БД
        (что бы реплики не отставали)
        
        20130822_calc_group_href_params.pl --sleep-coeff=1
        если реплики отстают, можно увеличить --sleep-coeff
        --min-bid - начать обработку с заданного bid (деплой можно запускать повторно)
      "
    },
]

=cut

use strict;
use warnings;
use utf8;
use lib::abs '../protected';

use Getopt::Long;
use Settings;
use Yandex::DBTools;
use ScriptHelper;

my $sleep_coeff = 1;
my $min_bid;
GetOptions(
    'sleep-coeff=i' => \$sleep_coeff,
    'min-bid=i' => \$min_bid
);
$sleep_coeff = 1 unless defined $sleep_coeff;
$min_bid ||= 0;

$log->out('start');
while (my $groups = get_next_groups()) {
    do_mass_insert_sql(PPC, 'INSERT IGNORE INTO group_params(pid, has_phraseid_href) VALUES %s',
                            [map {[$_, 1]} @$groups],
                            {
                                dont_quote => 1,
                                sleep => $sleep_coeff,
                                max_row_for_insert => 10000,
                            });
} 
$log->out('finish');

{
my $max_bid; 
sub get_next_groups {
    
    $max_bid = get_one_field_sql(PPC, 'select max(bid) from banners') unless $max_bid;
    $min_bid =  0 unless $min_bid;
    
    my $pids;
    my $limit = 200000;
    
    while (!$pids && $min_bid < $max_bid) {
        $pids = get_one_column_sql(PPC, 'select pid from banners where bid between ? and ? and (href like "%{phrase_id}%" or href like "%{phraseid}%")',
                                    $min_bid, $min_bid + $limit);
        $min_bid += $limit + 1;
        $log->out("processed $min_bid/$max_bid");
    }
    
    return $pids && @$pids ? $pids : undef;   
}
}
