#!/usr/bin/perl

use my_inc "..";


=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "5 мин",
  comment => "чистим ошибочные записи с cid is null из moderation_cmd_queue"
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use Yandex::Retry;;
use ScriptHelper;

use utf8;

$log->out('START');

my $SELECT_LIMIT = 100_000;
my $DELETE_LIMIT = 1_000;
while(1) {
    my $rows = get_all_sql(PPC, "SELECT * FROM moderation_cmd_queue WHERE cid is null LIMIT $SELECT_LIMIT");
    my $selected = @$rows;
    for my $row (@$rows) {
        $log->out($row);
    }
    while(my @chunk = splice @$rows, 0, $DELETE_LIMIT) {
        relaxed times => 2, sub {
            my $deleted = do_delete_from_table(PPC, "moderation_cmd_queue", where => {id => [map {$_->{id}} @chunk]});
            $log->out("deleted $deleted rows");
        };
    }
    last if $selected != $SELECT_LIMIT;
}

$log->out('FINISH');

