#!/usr/bin/perl

use my_inc "..";


=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "2m",
  comment => "
    перед началом работы
    scp ppcdev:/opt/ppc-data/deploy-data/20130826_passport_subscribe.pl.data /tmp/

    подписываем обратно пользователей, которые были отписаны в deploy/20130429_unsubscribe_uid_from_psp_cid.pl, но остались в базе
  "
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use Yandex::Passport;
use ScriptHelper;
use File::Slurp;

use utf8;

$log->out('START');

# список uid'ов взят из логов упомянутой миграции, пересечен с пользователями, присутствивующими в базе
# для надежности перед подпиской проверяем, что пользователь все еще есть в базе
my @uids = read_file('/tmp/20130826_passport_subscribe.pl.data', chomp => 1);

while (my @chunk = splice(@uids, 0, 1000)) {
    my $found = get_all_sql(PPC, [
        'select uid, login from users',
         where => {uid => \@chunk}
    ]) || [];

    for my $row (@$found) {
        my $res = Yandex::Passport::subscribe_service($row->{uid});
        $log->out("subscribe $row->{uid} $row->{login} " . ($res ? 'error' : 'ok'));
    }
}

$log->out('FINISH');
