#!/usr/bin/perl

use my_inc "..";


=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "3 часа",
  comment => "заполняем таблицы ppcdict.shard_order_id и shard_banner_id

    Запустить через час после выкладки пакетов

    можно запускать с коэффициентом --sleep-coef=N для вычисления паузы между итерациями
    (чтобы реплики не отставали)

  "
},
=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use Yandex::Retry;;
use ScriptHelper;

use utf8;

my $SLEEP = 1;
GetOptions(
    'sleep-coef=i' => \$SLEEP,
);

my $chunk = 100_000;

$log->out('START');

$log->out('OrderID');

my ($min, $max) = get_one_line_array_sql(PPC, "select min(OrderID), max(OrderID) from campaigns");
while ($min < $max) {
    $log->out(sprintf "OrderID $min / $max, %.2f%%", ($min/$max*100));
    relaxed times => $SLEEP, sub {
        do_insert_select_sql(PPC, 
            "insert ignore into shard_order_id (OrderID, ClientID) values %s",
            ["select c.OrderID, u.ClientID 
            from campaigns c
            join users u on u.uid = c.uid
            where c.OrderID > 0", and => { OrderID__between => [ $min, $min+$chunk ] } ],
            dbw => 'ppcdict',
            max_row_for_insert => $chunk,
            max_row_for_select => $chunk,
        );
    };
    $min += $chunk + 1;
}

$log->out('BannerID');

($min, $max) = get_one_line_array_sql(PPC, "select min(BannerID), max(BannerID) from banners");
while ($min < $max) {
    $log->out(sprintf "BannerID $min / $max, %.2f%%", ($min/$max*100));
    relaxed times => $SLEEP, sub {
        do_insert_select_sql(PPC, 
            "insert ignore into shard_banner_id (BannerID, ClientID) values %s",
            ["select b.BannerID, u.ClientID 
            from banners b 
            join phrases p on p.pid = b.bid
            join campaigns c on c.cid = p.cid
            join users u on u.uid = c.uid
            where b.BannerID > 0", and => { BannerID__between => [ $min, $min+$chunk ] }],
            dbw => 'ppcdict',
            max_row_for_insert => $chunk,
            max_row_for_select => $chunk,
        );
    };
    $min += $chunk + 1;
}

$log->out('FINISH');

