#!/usr/bin/perl

use my_inc "..";


=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => 'порядка 10 секунд',
  comment => 'удаляем пустые кампании с несовпадающей с клиентом валютой',
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

use Campaign;
use RBAC2::Extended;

use utf8;

my @cids_to_delete = (7380608, 7380371, 7381065, 7381074, 7377763,7380951);

$log->out('START');

my $campaigns = get_all_sql(PPC, ['SELECT cid, uid FROM campaigns', WHERE => {cid => \@cids_to_delete, statusEmpty => 'Yes'}]);
if ($campaigns && @$campaigns) {
    my $rbac = new RBAC2::Extended(RBAC, RBAC_SLAVE);
    $log->die("Can't connect to RBAC") if ! defined $rbac || ! $rbac->InitReq(1);

    for my $camp (@$campaigns) {
        $log->out("Deleting campaign", $camp);
        my $ret = eval { 
            del_camp(PPC, $rbac, $camp->{cid}, $camp->{uid}, force => 1); 
        };
        if ($@ || !$ret) {
            $log->out("Can't delete campaign $camp->{cid}: $@");
        }
    }
}

$log->out('FINISH');

