#!/usr/bin/perl

use my_inc "..";


=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "1мин 40сек",
  comment => "чистим таблицу auto_price_camp_queue для сокращения времени на последующий деплой"
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;

use ScriptHelper;
use Yandex::DBTools;
use Yandex::ListUtils;
use Yandex::Retry;

my $SIZE_OF_CHUNK = 10000;

$log->out('start');
my $ids = get_one_column_sql(PPC, "select id from auto_price_camp_queue where status != 'Wait'");

for my $chunk (chunks $ids, $SIZE_OF_CHUNK){
        relaxed( times => 3, sub { do_sql(PPC, ["delete from auto_price_camp_queue", where => { id => $chunk}]) });
        $log->out(Dumper($chunk));
}
$log->out('finish');
