#!/usr/bin/perl

use my_inc "..";


=head1 DEPLOY

# approved by lena-san
# .migr
{
    type => 'script',
    when => 'after',
    time_estimate => "5 min",
    comment => "проставляем правильный uid менеджера для агентств в clients",
}

=cut

# https://jira.yandex-team.ru/browse/DIRECT-24498

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;

use ScriptHelper;
use Yandex::DBTools;
use RBAC2::Extended;
use RBACElementary;
use RBACDirect;
use Common;
use BalanceQueue;

use List::MoreUtils qw/uniq/;
use Data::Dumper;

# --------------------------------------------------------------------
sub main {
    $log->out('start');
    local $Yandex::DBShards::STRICT_SHARD_DBNAMES = 0;

    my $rbac = get_singleton RBAC2::Extended();
    $rbac->InitReq(1) or $log->die("rbac error");

    my $all_agencies = rbac_get_all_agencies_chief_reps($rbac);
    my $all_client_ids = rbac_get_agencies_clientids_by_uids( $all_agencies);
    my $managers_of_agencies_clientids = rbac_get_all_managers_of_agencies_clientids($rbac, [uniq values %$all_client_ids]);
    my @camps_for_balance;
    do_sql(PPC, "SET SESSION group_concat_max_len = 1000000");

    for my $uid (keys %$all_client_ids) {
        my $ClientID = $all_client_ids->{$uid};
        my $old_client_row = get_one_line_sql(PPC, "select ClientID, primary_manager_uid, primary_bayan_manager_uid from clients where ClientID = ?", $ClientID);

        # пока правим только тех у которых нет директовского, но есть mcb-менеджер (баг который поправили в DIRECT-24498)
        if (! $old_client_row->{primary_manager_uid}
            && $old_client_row->{primary_bayan_manager_uid}
           )
        {
            my $camp_counts = get_hashes_hash_sql(PPC, "select c.type, count(*) as cnt, group_concat(c.cid) as cids
                                                        from campaigns c
                                                          join users ua on c.AgencyUID = ua.uid
                                                        where ua.ClientID = ?
                                                        group by c.type
                                                       ", $ClientID);

            $camp_counts->{mcb}->{cnt} ||= 0;
            $camp_counts->{text}->{cnt} ||= 0;

            # если менеджер один и нет медиа-кампаний, то предполагаем что менеджер для директа
            if ($camp_counts->{mcb}->{cnt} == 0
                && $managers_of_agencies_clientids->{$ClientID}
                && scalar(@{$managers_of_agencies_clientids->{$ClientID}}) == 1
               )
            {
                $log->out({old_client_row => $old_client_row});

                do_update_table(PPC, 'clients', {primary_manager_uid => $managers_of_agencies_clientids->{$ClientID}->[0]
                                                 , primary_bayan_manager_uid => undef
                                                }, where => {
                                                    ClientID => $ClientID
                                                    , primary_manager_uid__is_null => 1
                                                });

                $log->out({
                    update_clients => {
                        primary_manager_uid => $managers_of_agencies_clientids->{$ClientID}->[0]
                        , primary_bayan_manager_uid => undef
                    },
                    where => {ClientID => $ClientID}
                });

                # если записаный mcb-менеджер не совпадает с рбак-менеджером, то кампании нужно переотправить в биллинг
                if ($camp_counts->{text}->{cnt}
                    && $camp_counts->{text}->{cids}
                    && $old_client_row->{primary_bayan_manager_uid} != $managers_of_agencies_clientids->{$ClientID}->[0]
                   )
                {
                    push @camps_for_balance, $_ for split /\s*,\s*/, $camp_counts->{text}->{cids};
                }
            }
        }
    }

    $log->out({camps_for_balance_count => scalar(@camps_for_balance)});
    $log->out({camps_for_balance => \@camps_for_balance});
    # будет послано 5 кампаний (на devtest)
    for my $cid (@camps_for_balance) {
        BalanceQueue::add_to_balance_info_queue(PPC, 1, 'cid', $cid);
    }

    $log->out('finish');
}

# --------------------------------------------------------------------
main();
