#!/usr/bin/perl

use my_inc "..";


=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => 'минута-другая',
  comment => "убиваем дублирующиеся BannerID"
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

use Yandex::ListUtils;
use List::MoreUtils qw/uniq/;

my $BANNERID_CHUNK_SIZE = 1_000;
my $file = "$Bin/20130905_fix-duplicate-bannerid.data";

use utf8;

$log->out('START');

open( F, "<:encoding(utf8)", $file ) || $log->die($!);
my @bids = <F>;
close F;
chomp @bids;

$log->out('Updating');

for my $bids_chunk (chunks \@bids, $BANNERID_CHUNK_SIZE) {
    $log->out("Process chunk: ", $bids_chunk);
    my $old_banners = get_all_sql(PPC_HEAVY, ['SELECT bid, BannerID FROM banners WHERE', {bid => $bids_chunk}]) || [];
    $log->out('Old banners data:', $old_banners);
    my $old_banner_images = get_all_sql(PPC_HEAVY, ['SELECT image_id, bid, BannerID FROM banner_images WHERE', {image_id => $bids_chunk}]) || [];
    $log->out('Old banner_images data:', $old_banner_images);

    my @bids_to_resync = uniq map { $_->{bid} } @$old_banner_images;

    my $pids = get_one_column_sql(PPC_HEAVY, ['SELECT DISTINCT pid FROM banners WHERE', {bid => [@$bids_chunk, @bids_to_resync]}]) || [];

    my $phrases_updated_rows_cnt = do_update_table(PPC, 'phrases', {statusBsSynced => 'No'}, where => {pid => $pids});
    my $banners_updated_rows_cnt = do_update_table(PPC, 'banners', {BannerID => 0, statusBsSynced => 'No'}, where => {bid => $bids_chunk, BannerID__gt => 0});
    my $banner_images_updated_rows_cnt = do_update_table(PPC, 'banner_images', {BannerID => 0}, where => {image_id => $bids_chunk, BannerID__gt => 0});
    my $banner_resync_updated_rows_cnt = do_update_table(PPC, 'banners', {statusBsSynced => 'No'}, where => {bid => \@bids_to_resync});
    $log->out("Updated $phrases_updated_rows_cnt rows in phrases, $banners_updated_rows_cnt rows in banners, $banner_images_updated_rows_cnt rows in banner_images and $banner_resync_updated_rows_cnt rows to resync");
}

$log->out('FINISH');
