#!/usr/bin/perl

use my_inc "..";


=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "40 минут",
  comment => "привязываем в балансе uid к ClientID",
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use Yandex::TimeCommon qw/get_distinct_dates today/;
use Tools;
use Primitives;
use PrimitivesIds;
use Yandex::Balance;

use utf8;
use open ':std' => ':utf8';

$log->out('START');

my $start_date = '20130719';
my $end_date = today();
my @dates = get_distinct_dates($start_date, $end_date);
my $count = 0;
for my $date (@dates) {
    $log->out("date $date");
    my $rows = get_all_sql(PPCLOG_HEAVY, "select uid, param from logcmd_$date where cmd = 'saveClientID'") || [];
    $log->out("found @{[scalar @$rows]} rows");
    foreach my $row (@$rows) {
        my $param = Tools::parse_logcmd_param($row->{param});

        my $client_login = lc($param->{client_login});
        next unless $client_login;

        my $uid = get_one_field_sql(PPC(shard=>'all'), "select max(uid) from users where login=?", lc($client_login));
        next unless $uid;

        my $balance_client_id = Yandex::Balance::get_clientid_by_uid($uid);

        if (!$balance_client_id) {
            my $db_client_id = get_clientid(uid => $uid);
            Yandex::Balance::create_client_id_association($uid, $db_client_id, $row->{uid});
            $log->out(sprintf("create_client_id_association uid: %d, client_id: %d, operator_uid: %d", $uid, $db_client_id, $row->{uid}));
            $count++;
        }
    }
}

$log->out("total users associated: $count");

$log->out('FINISH');

__END__
# Во время предварительных пробных запусков находились следующие различия.
# У данных пользователей в балансе не прописан никакой ClientID, в нашей базе они прописаны.
create_client_id_association uid: 221790687, client_id: 2158142, operator_uid: 214218421
create_client_id_association uid: 223409441, client_id: 3103848, operator_uid: 214218421
create_client_id_association uid: 223477966, client_id: 3104111, operator_uid: 214218421
create_client_id_association uid: 223670612, client_id: 3110742, operator_uid: 214218421
create_client_id_association uid: 223677438, client_id: 2986818, operator_uid: 204529526
create_client_id_association uid: 223692594, client_id: 3065766, operator_uid: 214218421
create_client_id_association uid: 223699826, client_id: 3112378, operator_uid: 214218421
create_client_id_association uid: 223772754, client_id: 3113778, operator_uid: 214218421
create_client_id_association uid: 9037693, client_id: 1387022, operator_uid: 10956621
create_client_id_association uid: 224799069, client_id: 3123705, operator_uid: 214218421
create_client_id_association uid: 224888559, client_id: 469252, operator_uid: 53587779
create_client_id_association uid: 224899950, client_id: 2241721, operator_uid: 127884589
create_client_id_association uid: 224929394, client_id: 3147962, operator_uid: 214218421
create_client_id_association uid: 225208250, client_id: 1266859, operator_uid: 214218421
create_client_id_association uid: 225442147, client_id: 3147883, operator_uid: 214218421
create_client_id_association uid: 225454142, client_id: 3130045, operator_uid: 214218421
create_client_id_association uid: 226205407, client_id: 3191639, operator_uid: 214218421
create_client_id_association uid: 226209130, client_id: 3122667, operator_uid: 214218421
create_client_id_association uid: 226337721, client_id: 3195416, operator_uid: 224810905
create_client_id_association uid: 226445478, client_id: 3198700, operator_uid: 224810905
create_client_id_association uid: 226456210, client_id: 3198102, operator_uid: 214218421
create_client_id_association uid: 226523034, client_id: 497911, operator_uid: 164723541
create_client_id_association uid: 226965864, client_id: 3214095, operator_uid: 131567284

