#!/usr/bin/perl

use my_inc "..";


=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => 'полминуты',
  comment => 'удаляем таблицы ppcstat_data.currency_rates, переехавшие в direct_stat',
},

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

use utf8;

$log->out('START');

for my $db (sort @{get_db_childs('ppcstat')}) {
    $log->out("Dropping direct_stat.currency_rates in $db");
    my $res = eval {
        do_sql($db, q/DROP TABLE IF EXISTS ppcstat_data.currency_rates/);
        return 1;
    };
    if (!$res) {
        $log->out("ERROR dropping table in $db: $@");
    }
}

$log->out('FINISH');
