#!/usr/bin/perl

use my_inc "..";


=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => 'несколько секунд',
  comment => 'затираем страну уешным клиентам со страной, конфликтующей с прошлыми оплатами',
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

use File::Slurp;
local $Yandex::DBShards::STRICT_SHARD_DBNAMES = 0;

use utf8;

$log->out('START');

my @clientids = read_file("$Bin/20130919_reset-country-on-problematic-YND_FIXED-clients.data");
chomp @clientids;

$log->out("Resettings country for YND_FIXED clients with clientid:", \@clientids);
my $affected_cnt = do_sql(PPC, ['UPDATE clients SET country_region_id = 0, create_date=create_date WHERE IFNULL(work_currency, "YND_FIXED") = "YND_FIXED" AND', {ClientID => \@clientids}]);
$log->out("Updated $affected_cnt rows");

$log->out('FINISH');
