#!/usr/bin/perl

use my_inc "..";


=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '1 час на dev7',
  comment => 'обновляем mediaplan_bids.phraseIdHistory из mediaplan_bids.bsIdHistory',
},

=cut

use warnings;
use strict;

use FindBin qw/$Bin/;
use lib "$Bin/../protected"; 

use Data::Dumper;
use List::MoreUtils qw/uniq/;

use Yandex::DBTools;
use Yandex::HTTP qw/http_parallel_request/;

use Settings;
use ScriptHelper;
use Tools;
local $Yandex::DBShards::STRICT_SHARD_DBNAMES = 0;


our $priority2banner_url = 'http://bssoap.yandex.ru/export/priority-to-banner.cgi';


run() unless caller();

sub run
{
    $log->out("START");

    my $max_cid = get_one_field_sql(PPC, "select max(cid) from campaigns");

    my $chunk_size = 1_000;
    my $chunks = int($max_cid/$chunk_size) + 1;
    $log->out("max(cid): $max_cid, chunk_size: $chunk_size, chunks: $chunks");
    
    # mediaplan_bids
    $log->out("from mediaplan_bids.bsIdHistory to mediaplan_bids.phraseIdHistory - start");
    for my $n (0 .. $chunks - 1){
        my $start = $chunk_size * $n;
        my $end = $start + $chunk_size - 1;
        $log->out("processing cid $start .. $end");
        my $bids_bs_history = get_all_sql(PPC, 
            "select cid, id, bsIdHistory, phraseIdHistory phraseIdHistory_old from 
            mediaplan_bids  
            where bsIdHistory is not null and cid between ? and ?", 
            $start, $end
        ) || [];
        next if scalar @$bids_bs_history == 0;
        fill_banner_id_cache($bids_bs_history);
        for my $o (@$bids_bs_history){
            $o->{phraseIdHistory} = bsIdHistory_to_phraseIdHistory($o->{cid}, $o->{bsIdHistory});
        }
        while (my @chunk = splice(@$bids_bs_history, 0, 1000)) {
            foreach (@chunk) {
                $log->out($_) if $_->{phraseIdHistory} ne ($_->{phraseIdHistory_old} || '');
            }
            do_update_table(
                PPC,
                'mediaplan_bids',
                {phraseIdHistory__dont_quote => sql_case(PPC, 'bsIdHistory', {map {$_->{bsIdHistory} => $_->{phraseIdHistory}} @chunk}, default__dont_quote => '""')},   
                where => {id => [map {$_->{id}} @chunk]}
            );
        }
        clear_banner_id_cache();
    }

    $log->out("from mediaplan_bids.bsIdHistory to mediaplan_bids.phraseIdHistory - done");

    $log->out("FINISH");
}


sub bsIdHistory_to_phraseIdHistory
{
    my ($cid, $bsIdHistory) = @_;

    return '' if ! defined $bsIdHistory || $bsIdHistory eq '';

    my @old_ids = split ",", $bsIdHistory;
    my @new_ids;
    for my $i (0 .. scalar(@old_ids) - 1){
        if ( $i % 2 == 1 ){
            push @new_ids, $old_ids[$i];
        } else {
            push @new_ids, "B".get_banner_id($cid, $old_ids[$i]);
        }
    }
    return join (",", @new_ids);
}


{
    my %BANNER_ID;

sub get_banner_id
{
    my ($cid, $PriorityID) = @_;
    my $BannerID = $BANNER_ID{$PriorityID};
    $log->out("no BannerID for cid = $cid, PriorityID = $PriorityID") unless $BannerID;
    $BannerID = '' if ! defined $BannerID;
    return $BannerID;
}

sub fill_banner_id_cache
{
    my ($hists) = @_;

    my @priority_ids;
    my %CID;
    for my $o (@$hists){
        my @old_ids = split ",", $o->{bsIdHistory};
        my @new_ids;
        for my $i (0 .. scalar(@old_ids) - 1){
            if ( $i % 2 == 1 ){
            } else {
                push @priority_ids, $old_ids[$i];
                $CID{$old_ids[$i]} = $o->{cid};
            }
        }
    }

    my @old_priority_ids;
    for my $PriorityID (@priority_ids){
        if (!exists $BANNER_ID{$PriorityID}){
            push @old_priority_ids, $PriorityID;
        }
    }

    @old_priority_ids = uniq @old_priority_ids;
    while (@old_priority_ids){
        my @chunk = splice(@old_priority_ids,0,100);
        my $url = sprintf "$priority2banner_url?priorityids=%s", join(",", @chunk);
        $log->out("url: $url");
        my $resp = http_parallel_request(
            GET => { 1 => {url => $url}}, 
            num_attempts => 5,
        );
        my $s = $resp->{1}->{content};
        $s =~ s/^.*?$//sm;
        $s =~ s/^#End$//sm;
        for my $pair (split /[,\n]+/, $s){
            $pair =~ /^(\d+)-(\d+)$/;
            next unless $1 && $2;
            $BANNER_ID{$1} = $2;
        }
    }

    return '';
}

sub clear_banner_id_cache
{
    %BANNER_ID = ();
}

}



