#!/usr/bin/perl

use my_inc "..";


=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => 'на dev7 35 минут, на production ожидается порядка 5 минут',
  comment => 'проставляем тем баннерам кампании у которых он пустой,- регион, установленный у остальных баннеров, если он у всех одинаков 
  			 (предположительно регион стал пустым в результате ошибки при копировании).
  			 Берем только кампании у которых общий geo не устанавливался (такие мы исправили ранее)',
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use GeoTools;
use List::MoreUtils qw/uniq/;
use utf8;

local $Yandex::DBShards::STRICT_SHARD_DBNAMES = 0;

$log->out('START');

my $date_of_release_with_error = '2013-08-12'; # дата когда выехал релиз с группами, в котором, скорей всего, появилась ошибка
my $total_updated_pids = 0;

$log->out('fetching problematic campains/pids from database');
my $camps = get_all_sql(PPC_HEAVY, "SELECT c.cid, GROUP_CONCAT(p.pid) as pids 
                                      FROM campaigns c 
                                      JOIN phrases p FORCE INDEX (LastChange) on p.cid = c.cid and p.geo is null and p.LastChange >= ?
                                     WHERE IFNULL(c.geo, 0) = 0
                                  GROUP BY c.cid", $date_of_release_with_error);
$log->out('fetched ' . scalar(@$camps) . ' campaigns');
foreach my $camp (@$camps) {
    $log->out("processing cid=$camp->{cid}");
    #проверяем что в кампании есть баннеры с выставленным регионом, и он у всех баннеров одинаков
    my $geoflag;
    my $banners_geo = get_one_column_sql(PPC_HEAVY, "SELECT DISTINCT geo FROM phrases WHERE cid = ? AND geo IS NOT NULL", $camp->{cid});
    @$banners_geo = uniq map { $_ = refine_geoid($_, \$geoflag) } @$banners_geo;
    
    if (!@$banners_geo) {
        $log->out("skip cid=$camp->{cid} : no geo selected over campaign banners");
        next;
    } elsif (@$banners_geo > 1) {
        # после миграции надо посмотреть, много ли таких кампаний
        $log->out("skip cid=$camp->{cid} : more than 1 geo selected over campaign banners");
        next;
    }

    my $geo = $banners_geo->[0];
    my @pids = split ',', $camp->{pids};
    foreach my $pid (@pids) {
        $log->out("trying to update pid with geo=$geo: cid=$camp->{cid}, pid=$pid");
        my $rows_updated = do_update_table(PPC, 'phrases', {
            geo => $geo,
            statusBsSynced => 'No',
            LastChange__dont_quote => 'LastChange',
            statusShowsForecast => 'New'
        }, where => {cid => $camp->{cid}, 
                     pid => $pid,
                     geo__is_null => 1});
        unless ($rows_updated > 0) {
            $log->out("skip cid=$camp->{cid}, pid=$pid: geo is not null (or pid not exists)");
            next;
        }

        do_update_table(PPC, 'banners', {
            geoflag => $geoflag,
            statusBsSynced => 'No',
            LastChange__dont_quote => 'LastChange',
            statusPostModerate__dont_quote => "IF(statusPostModerate = 'Rejected', 'Rejected', 'No')",
            statusModerate__dont_quote => "IF(statusModerate = 'New', 'New', 'Ready')"
        }, where => {cid => $camp->{cid}, 
                     pid => $pid});
        $total_updated_pids ++;
    }

}
$log->out("total updated pids qty: $total_updated_pids");
$log->out('FINISH');

