#!/usr/bin/perl

use my_inc "..";


=head1 DEPLOY

# approved by zhur
# .migr
[
  {
    type => 'script',
    when => 'after',
    time_estimate => '10 часов',
    comment => qq!
запустить на одном из ppcback,
если потребуется перезапустить - нужно взять в логе последнюю запись "start process YYYYMMDD" и перезарустить с параметром --from YYYYMMDD
если будет слишком грузить ppclog - можно перезапустить с параметром --sleep-coef 3
!,
  },
  {
    type => 'sql',
    webstop => "0",
    db => "ppclog",
    when => 'instructions',
    instructions => 'запустить после того как корректно отработает скрипт, желательно не в час пик',
    time_estimate => "5 секунд",
    sql => "DROP TABLE moderate_history",
  },
]

=cut

use strict;
use warnings;

use Getopt::Long;

use Yandex::DBTools;
use Yandex::DBSchema;
use Yandex::TimeCommon;
use Yandex::Retry;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use ScriptHelper;

use utf8;
$log->out("start");

my $FROM = 20120101;
my $SLEEP_COEF = 1;
GetOptions(
    "from=s" => \$FROM,
    "sleep-coef=i" => \$SLEEP_COEF,
) || die "Can't parse params: $!";

$FROM ||= get_one_field_sql(PPCLOG_HEAVY, "select date(min(logtime)) from moderate_history");
for my $date (get_distinct_dates($FROM, today())) {
    $log->out("start process $date");
    my $suf = substr($date, 0, 6);
    create_table_by_schema(PPCLOG, "moderate_history_$suf", like => "ppclog.moderate_history_YYYYMM", if_not_exists => 1);
    relaxed times => $SLEEP_COEF, sub {
        my $cnt = do_insert_select_sql(PPCLOG_HEAVY, "INSERT INTO moderate_history_$suf (logtime, uid, cid, bid, statusModerate) values %s",
                         "SELECT logtime, uid, cid, bid, statusModerate FROM moderate_history WHERE logtime >= ? and logtime < ?",
                         dbw => PPCLOG, binds => [$date, tomorrow($date)]
                        );
        $log->out("moved $cnt rows");
    };
}
