#!/usr/bin/perl

use my_inc "..";


=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "4мин 40сек",
  comment => "выставляем status_click_track всем у кого выставлена satusOpenStat (см. тикет DIRECT-24405)"
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;

use ScriptHelper;
use Yandex::DBTools;
use Yandex::ListUtils;
use Yandex::Retry;

local $Yandex::DBShards::STRICT_SHARD_DBNAMES = 0;
my $SIZE_OF_CHUNK = 1000;
my $DEPLOY_TIME = '2013-10-07 14:58:00';

$log->out('start');
my $cids = get_one_column_sql(PPC,
    "select cid from campaigns c join camp_options co using(cid) where c.statusOpenStat = 'Yes' and c.archived = 'No' and co.create_time <= '$DEPLOY_TIME'");

for my $chunk (chunks $cids, $SIZE_OF_CHUNK){

        my $update = sprintf qq{
            UPDATE campaigns c join camp_options co using(cid)
            SET co.status_click_track = 1
            WHERE
                c.cid in (%s)
                and c.statusOpenStat = 'Yes'
                and c.archived = 'No'
                and co.create_time <= '$DEPLOY_TIME'},
            join(',', @$chunk);

        relaxed(times => 3,
                sub { do_sql(PPC, $update); do_mass_insert_sql(PPC,"INSERT IGNORE INTO bs_resync_queue (cid) VALUES %s", [map { [$_] } @$chunk])});

        $log->out($chunk);
}
$log->out('finish');

