#!/usr/bin/perl

use my_inc "..";


=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "несколько часов",
  comment => "Добавляем новый формат баннерной картинки
Перед запуском сделать scp ppcdev-precise:/home/icenine/banner_images_y65_size /tmp

Можно запускать с опцией --sleep-coef N чтобы реплики не отставали
  "
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use File::Slurp;
use JSON;
use Yandex::HashUtils;
use Yandex::Retry qw/relaxed/;

use utf8;

my $SLEEP_COEF = 1;
GetOptions(
    "sleep-coef=i" => \$SLEEP_COEF,
);

$log->out('START');

$log->out("loading file");

my %new_size_for;
for my $l (read_file("/tmp/banner_images_y65_size")) {
    chomp $l;
    my ($hash, $size) = split /\s+/, $l; 
    my ($x, $y) = ($size =~ /size=(\d+)x(\d+)/); 
    unless ($y && $y == 65) {
        $log->out("MISSING size in file for hash '$hash'");
        next;
    }

    $new_size_for{$hash} = { y65 => { width => $x, height => $y} };
}

$log->out("selecting existing images");
my %update;
my @resend;
my $count_all = get_one_field_sql(PPC_HEAVY(shard => 'all'), "select count(*) from banner_images_formats");
$log->out("$count_all images to go");
my $sth = exec_sql(PPC_HEAVY(shard => 'all'), "select image_hash, formats from banner_images_formats");
my $cnt = 0;
my $error_cnt = 0;
while (my ($hash, $formats_json) = $sth->fetchrow_array) {
    $cnt++;
    $log->msg_prefix("[$cnt/$count_all]");
    my $formats = from_json($formats_json);
    if ($formats->{y65}) {
        $log->out("already in new format: $hash");
        push @resend, $hash;
    } else {
        my $size = $new_size_for{$hash};
        if (!$size) {
            $log->out("MISSING new size for $hash");
            $error_cnt++;
        } else {
            $formats = hash_merge $formats, $size;
            $update{$hash} = to_json($formats);
            $log->out("$hash: $update{$hash}");
        }
    }

    if (keys %update > 500) {
        _update(\%update);
        %update = ();
    }
    if (@resend > 500) {
        _resend(\@resend);
        @resend = ();
    }
}

if (keys %update) {
    _update(\%update);
}
if (@resend) {
    _resend(\@resend);
}

$log->msg_prefix("");

$log->out("MISSING size for $error_cnt images (grep MISSING on log file)");

$log->out('FINISH');

exit;

###

sub _update
{
    my $update = shift;
    $log->out("updating banner_images_formats");
    my $hash2format_sql = sql_case('image_hash', $update);
    relaxed times => $SLEEP_COEF, sub {
        do_sql(PPC(shard => 'all'), [ "update banner_images_formats set formats = ", $hash2format_sql, 
                where => { image_hash => [ keys %$update ] } ]);
    };
    _resend([ keys %$update ]);
}

sub _resend
{
    my $hashes = shift;
    $log->out("inserting to bs_resync_queue");
    relaxed times => $SLEEP_COEF, sub {
        do_sql(PPC(shard => 'all'), [
            "insert ignore into bs_resync_queue (cid, bid)
             select p.cid, b.bid from banners b join phrases p on p.pid = b.pid join banner_images bim on bim.bid = b.bid",
             where => {
                 'bim.image_hash' => $hashes,
             }
        ]);
    };
}
