#!/usr/bin/perl

use my_inc "..";


=head1 DEPLOY

# approved by zhur
# .migr
[
  {
    type => 'sql',
    webstop => "0",
    db => "ppcdict",
    when => 'before',
    time_estimate => "1 sec",
    sql => [
      "CREATE TABLE IF NOT EXISTS shard_inc_mediaplan_bid (mediaplan_bid int unsigned not null PRIMARY KEY auto_increment, ClientID int unsigned not null, index(ClientID));",
      "CREATE TABLE IF NOT EXISTS inc_mediaplan_phid (mediaplan_phid int unsigned not null PRIMARY KEY  auto_increment);",
      "CREATE TABLE IF NOT EXISTS inc_mediaplan_ret_id (mediaplan_ret_id int unsigned not null PRIMARY KEY  auto_increment);",
      "CREATE TABLE IF NOT EXISTS inc_mediaplan_mpid (mediaplan_mpid int unsigned not null PRIMARY KEY  auto_increment);",
      "CREATE TABLE IF NOT EXISTS inc_opt_camp_request_id (opt_camp_request_id int unsigned not null PRIMARY KEY  auto_increment);",
      "CREATE TABLE IF NOT EXISTS inc_opt_camp_postpone_id (opt_camp_postpone_id int unsigned not null PRIMARY KEY  auto_increment);",
    ]
  },
  {
    type => 'manual',
    when => 'instructions',
    instructions => 'см. описание',
    time_estimate => '5 минут до пакетов, 5 минут после',
    text => q!

  1. Инициализируем таблицы shard_inc_mediaplan_bid, inc_mediaplan_phid, inc_mediaplan_ret_id, inc_mediaplan_mpid, inc_opt_camp_request_id, inc_opt_camp_postpone_id  достаточно большими id.
  На один из  ppcback'ов выложить пакет yandex-direct-deploy-files релизной версии 
  Важно: выкладывать только этот один пакет, остальной Директ не обновлять.
  Выполнить скрипт, 2 секунды 
    
  perl -I/var/www/ppc.yandex.ru/protected /opt/ppc-data/deploy-files/deploy/20131015_shard_mediaplan_banners.pl --inc --clean

  Следующий пункт нужно делать сразу же после первого, пауза не больше 5 минут, если что - можно перезапустить

  2. Меняем offset'ы в ppc и ppcdict, чтобы во время выкладки не было коллизий

  В базе ppc 
  lm ppcdata1 sql 'set global auto_increment_increment = 2; set global auto_increment_offset = 1;'

  В базе ppcdict
  lm ppcdict sql 'set global auto_increment_increment = 2; set global auto_increment_offset = 2;'

  на одном из ppcback
  direct-clus PERL apache-reload

  Для контроля:
  Запускаем
  LOG_TEE=1 perl -I/var/www/ppc.yandex.ru/protected /opt/ppc-data/deploy-files/deploy/20131015_shard_mediaplan_banners.pl --check1
  Работает несколько минут. Выполнится две проверки. Если на обе проверки скрипт написал "OK", идем дальше. Если скрипт сообщил "FAIL": повторить запуск еще раз. 
  Если три запуска дают ошибки - сообщить релиз-менеджеру.
  Релиз-менеджеру же обратиться к n-boy@

  3. Пакеты
  
  Проверяем, что mediaplan_banners.mbid перестали выдаваться: 
  Запускаем
  LOG_TEE=1 perl -I/var/www/ppc.yandex.ru/protected /opt/ppc-data/deploy-files/deploy/20131015_shard_mediaplan_banners.pl --check2
  Работает несколько минут. Выполнится две проверки. Если на обе проверки скрипт написал "OK", идем дальше. Если скрипт сообщил "FAIL": повторить запуск еще раз. 
  Если три запуска дают ошибки - сообщить релиз-менеджеру.
  Релиз-менеджеру же обратиться к n-boy@

  4. Меняем offset'ы обратно:
  
  на мастере ppcdata1
  lm ppcdata1 sql 'set global auto_increment_increment = 1; set global auto_increment_offset = 1;'

  на мастере ppcdict
  lm ppcdict sql 'set global auto_increment_increment = 1; set global auto_increment_offset = 1;'

  на одном из ppcback
  direct-clus PERL apache-reload

  5. Заполняем таблицу ppcdict::shard_inc_mediaplan_bid;
  скрипт, около 5 минут: 
  /var/www/ppc.yandex.ru/protected/maintenance/check-sharding-metabase.pl --fix-absent --key mediaplan_bid

Если придется откатывать полностью выложенный релиз: 
Установить разные оффсеты на ppc и ppcdict (п. 2), 
откатить пакеты, 
вернуть offset=1 для ppc и ppcdict (п.4)

Повторная выкладка: 
в целом все надо повторить, но точную инструкцию надо будет составлять с учетом возникших проблем и того, насколько полностью все выложили в первый раз. 
    !,
  },
]

=cut


use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use CheckShardMetabaseId;

use utf8;

local $Yandex::DBShards::STRICT_SHARD_DBNAMES = 0;

my $INIT_INCREMENT = 0;
my $CHECK1 = 0;
my $CHECK2 = 0;
my $CLEAN = 0;

GetOptions("inc" => \$INIT_INCREMENT,
           "check1" => \$CHECK1,
           "check2" => \$CHECK2,
           "clean" => \$CLEAN
          );

my %tables = ('mbid'   => 'mediaplan_banners',
              'id'     => 'mediaplan_bids',
              'ret_id' => 'mediaplan_bids_retargeting',
              'mpid'   => 'mediaplan_stats',
              'request_id' => 'optimizing_campaign_requests');
# пришлось разбить на два списка таблиц, посколько поле id повторяется
my %tables2 = ('id'     => 'optimizing_campaign_postpone');


$log->out('START');

if ($INIT_INCREMENT) {
    # в среднем выдается около 12_000 новых mbid в день, значит приблизительно 3_000 в час (если взять пиковую середину дня, и представить что она длится 4 часа)
    my $MEDIAPLAN_BID_OFFSET = 100_000;
    my $max_mediaplan_bid = get_one_field_sql(PPC, "select max(mbid)+$MEDIAPLAN_BID_OFFSET from mediaplan_banners") || $MEDIAPLAN_BID_OFFSET;
    $log->out("init shard_inc_mediaplan_bid auto_increment with $max_mediaplan_bid");
    do_sql(PPCDICT, "replace into shard_inc_mediaplan_bid values (?,0)", $max_mediaplan_bid);

    # в среднем выдается около 90_000 новых mediaplan_bids.id в день, значит приблизительно 20_000 в час (если взять пиковую середину дня, и представить что она длится 4 часа)
    my $MEDIAPLAN_PHID_OFFSET = 150_000;
    my $max_mediaplan_phid = get_one_field_sql(PPC, "select max(id)+$MEDIAPLAN_PHID_OFFSET from mediaplan_bids") || $MEDIAPLAN_PHID_OFFSET;
    $log->out("init inc_mediaplan_phid auto_increment with $max_mediaplan_phid");
    do_sql(PPCDICT, "replace into inc_mediaplan_phid values (?)", $max_mediaplan_phid);    

    # в среднем выдается около 50 новых mediaplan_bids_retargeting.ret_id в день, значит приблизительно 15 в час (если взять пиковую середину дня, и представить что она длится 4 часа)
    # для большей пуленепробиваемости, берем 10_000
    my $MEDIAPLAN_RET_ID_OFFSET = 10_000;
    my $max_mediaplan_ret_id = get_one_field_sql(PPC, "select max(ret_id)+$MEDIAPLAN_RET_ID_OFFSET from mediaplan_bids_retargeting") || $MEDIAPLAN_RET_ID_OFFSET;
    $log->out("init inc_mediaplan_ret_id auto_increment with $max_mediaplan_ret_id");
    do_sql(PPCDICT, "replace into inc_mediaplan_ret_id values (?)", $max_mediaplan_ret_id);

    # в среднем выдается около 120 новых mediaplan_stats.mpid в день, значит приблизительно 30 в час (если взять пиковую середину дня, и представить что она длится 4 часа)
    my $MEDIAPLAN_MPID_OFFSET = 10_000;
    my $max_mediaplan_mpid = get_one_field_sql(PPC, "select max(mpid)+$MEDIAPLAN_MPID_OFFSET from mediaplan_stats") || $MEDIAPLAN_MPID_OFFSET;
    $log->out("init inc_mediaplan_mpid auto_increment with $max_mediaplan_mpid");
    do_sql(PPCDICT, "replace into inc_mediaplan_mpid values (?)", $max_mediaplan_mpid);

    # в среднем выдается около 120 новых optimizing_campaign_requests.request_id в день, значит приблизительно 30 в час (если взять пиковую середину дня, и представить что она длится 4 часа)
    my $OPT_CAMP_REQUEST_ID_OFFSET = 10_000;
    my $max_opt_camp_request_id = get_one_field_sql(PPC, "select max(request_id)+$OPT_CAMP_REQUEST_ID_OFFSET from optimizing_campaign_requests") || $OPT_CAMP_REQUEST_ID_OFFSET;
    $log->out("init inc_opt_camp_request_id auto_increment with $max_opt_camp_request_id");
    do_sql(PPCDICT, "replace into inc_opt_camp_request_id values (?)", $max_opt_camp_request_id);

    # в среднем выдается около 30 новых optimizing_campaign_postpone.id в день, значит приблизительно 10 в час (если взять пиковую середину дня, и представить что она длится 4 часа)
    my $OPT_CAMP_POSTPONE_ID_OFFSET = 10_000;
    my $max_opt_camp_postpone_id = get_one_field_sql(PPC, "select max(id)+$OPT_CAMP_POSTPONE_ID_OFFSET from optimizing_campaign_postpone") || $OPT_CAMP_POSTPONE_ID_OFFSET;
    $log->out("init inc_opt_camp_postpone_id auto_increment with $max_opt_camp_postpone_id");
    do_sql(PPCDICT, "replace into inc_opt_camp_postpone_id values (?)", $max_opt_camp_postpone_id);

    $log->out("INIT FINISH");
}
if ($CHECK1) {
    CheckShardMetabaseId::check(0, \%tables, $log);
    CheckShardMetabaseId::check(0, \%tables2, $log);
}
if ($CHECK2) {
    CheckShardMetabaseId::check(1, \%tables, $log);
    CheckShardMetabaseId::check(1, \%tables2, $log);
}
if ($CLEAN) {
    $log->out("clean inconsistent records");
    my $mbids = get_one_column_sql(PPC, "select b.mbid 
                                           from mediaplan_banners b
                                      left join campaigns c on c.cid = b.cid
                                      left join users u on c.uid = u.uid
                                          where IFNULL(u.ClientID, 0) = 0 ") || [];
    $log->out(sprintf("mbids to delete (%d): %s", scalar(@$mbids), (join(',', @$mbids) || 'nothing to delete')));
    if (@$mbids) {
        foreach my $t (qw/mediaplan_banners mediaplan_banners_original mediaplan_bids mediaplan_bids_retargeting/) {
            $log->out("delete from $t");
            do_delete_from_table(PPC, $t, where => { mbid => $mbids });
        }
    }
    $log->out("CLEAN FINISH");
}