#!/usr/bin/perl

use my_inc "..";


=head1 DEPLOY

# approved by zhur
# .migr
[
    {
      type => 'sql',
      webstop => "0",
      db => "monitor",
      when => 'before',
      time_estimate => "1 sec",
      sql => "CREATE TABLE `antispam_check_result` (
      `href_hash` bigint(20) unsigned NOT NULL,
      `type` enum('zora_content_rules','hb_content_rules','viruses','redirect','verdicts') NOT NULL,
      `value` varchar(1024) NOT NULL,
      `check_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
      PRIMARY KEY (`href_hash`, `type`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8;"
    },
    {
      type => 'script',
      when => 'after',
      time_estimate => '4 часа',
      comment => 'заполнить таблицу antispam_check_result текущими значениями из antispam_queue',
    }
]

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use utf8;
use Antispam;

$log->out('START');

my $READ_LIMIT = 100_000;
my $INSERT_LIMIT = 1_000;


my $request_id = 0;
my $max_request_id = 0;
GetOptions(
    'request_id=i' => \$request_id,
    'max_request_id=i' => \$max_request_id,
);

# Так как скрипт запустится после выкладки пакетов, то все новые данные уже будут заполняться в новую таблицу, нет смысла их перезаписывать.
$max_request_id = Antispam::get_max_id() unless $max_request_id;
$log->out("Start to fill request ids from $request_id to $max_request_id");
while ($request_id < $max_request_id) {
    $log->out("request_id: $request_id");
    my $requests = get_all_sql(MONITOR, 'SELECT * FROM antispam_queue WHERE request_id>? AND request_id<=? AND status != ? ORDER BY request_id LIMIT ?', 
                               $request_id, $max_request_id, $Antispam::STATUS_DELETE, $READ_LIMIT);
    last if !scalar(@$requests);
    my @result_values = ();
    foreach my $request (@$requests) {
        foreach my $field (@Antispam::RESULT_FIELDS) {
            next if $field eq 'verdicts';
            next if Antispam::is_empty($request->{$field});
            push @result_values, [$request->{href_hash}, $field, $request->{$field}];
        }
    }
    $log->out(sprintf("insert %d rows",scalar(@result_values)));

    do_mass_insert_sql(MONITOR, 
                       "INSERT IGNORE INTO antispam_check_result (href_hash, type, value) VALUES %s", 
                       \@result_values,
                       {max_row_for_insert => $INSERT_LIMIT}) if scalar(@result_values);
    $request_id = $requests->[-1]->{request_id};
}

$log->out('FINISH');
