#!/usr/bin/perl

use my_inc "..";


=head1 DEPLOY

# approved by mirage 
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "4 минуты",
  comment => "Добавляем флаг о табачной тематике объявлений:

1. Скопировать файл ppcdev-precise:/home/mirage/banners-fix-tobacco-flags-ids на сервер, где запускается деплой-скрипт в продакшене
2. Запустить скрипт с указанием в качестве параметра полный путь к этому файлу, например так:
  /var/www/ppc.yandex.ru/deploy/20131115_fix_tobacco_flag.pl /home/mirage/banners-fix-tobacco-flags-ids
"
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use Yandex::DBShards;
use ScriptHelper;
use File::Slurp;
use Yandex::HashUtils;
use utf8;

local $Yandex::DBShards::STRICT_SHARD_DBNAMES = 0;

$log->out('START');

my @bids = read_file($ARGV[0]);
my @filtered_bids = map { s/\D//gs; $_ } @bids;

die "No bids defined" unless scalar @filtered_bids && @filtered_bids > 10000;

while (my @chunk = splice @filtered_bids, 0, 1000) {

	my $res = do_sql(PPC, ["update banners 
						set flags = concat(flags, IF(flags != '', ',tobacco', 'tobacco'))
							, statusBsSynced='No' 
						where", { bid => \@chunk }]);
	$log->out({chunk => \@chunk, res => $res});
	sleep(1);
}

$log->out('FINISH');

