#!/usr/bin/perl

use my_inc "..";


=head1 DEPLOY

# approved by zhur
# .migr
[
  {
  type => 'sql',
  webstop => "0",
  db => "ppcdict",
  when => 'before',
  time_estimate => "1 секунда",
  sql => [
      "CREATE TABLE IF NOT EXISTS inc_maps_id (maps_id int unsigned not null PRIMARY KEY auto_increment)",
      "CREATE TABLE IF NOT EXISTS inc_report_id (report_id int unsigned not null PRIMARY KEY auto_increment)",
      "CREATE TABLE IF NOT EXISTS inc_mcb_phrases_id (mcb_phrases_id int unsigned not null PRIMARY KEY auto_increment)",
      "CREATE TABLE IF NOT EXISTS shard_inc_banner_images_pool_id (
                    banner_images_pool_id int unsigned not null PRIMARY KEY auto_increment,
                    ClientID int unsigned not null,
                    index(ClientID)
                )",
      "CREATE TABLE IF NOT EXISTS inc_banner_images_process_queue_id (banner_images_process_queue_id int unsigned not null PRIMARY KEY auto_increment)",
      "CREATE TABLE IF NOT EXISTS inc_users_notification_id (users_notification_id int unsigned not null PRIMARY KEY auto_increment)",
      ]
  },
  {
  type => 'sql',
  webstop => "0",
  db => "ppc",
  when => 'before',
  time_estimate => "5 секунд",
  sql => [
      "ALTER TABLE banner_images_pool MODIFY COLUMN create_time TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP",
      ]
  },
  {
    type => 'manual',
    when => 'instructions',
    instructions => 'см. описание',
    time_estimate => '5 минут до пакетов, 5 минут после',
    text => q!

  1. Инициализируем таблицы inc_maps_id достаточно большим id.
  На один из  ppcback'ов выложить пакет yandex-direct-deploy-files релизной версии 
  Важно: выкладывать только этот один пакет, остальной Директ не обновлять.
  Выполнить скрипт, 2 секунды 
    
  perl -I/var/www/ppc.yandex.ru/protected/ /opt/ppc-data/deploy-files/deploy/20131115_shard_maps.pl --inc

  Следующий пункт нужно делать сразу же после первого, пауза не больше 5 минут, если что - можно перезапустить

  2. Меняем offset'ы в ppc и ppcdict, чтобы во время выкладки не было коллизий

  В базе ppc 
  lm ppcdata1 sql 'set global auto_increment_increment = 2; set global auto_increment_offset = 1;'

  В базе ppcdict
  lm ppcdict sql 'set global auto_increment_increment = 2; set global auto_increment_offset = 2;'

  на одном из ppcback
  direct-clus PERL apache-reload

  Для контроля:
  Запускаем
  LOG_TEE=1 perl /opt/ppc-data/deploy-files/deploy/20131115_shard_maps.pl --check1
  Работает несколько минут. Если скрипт написал "OK", идем дальше. Если скрипт сообщил "FAIL": повторить запуск еще раз. 
  Если три запуска дают ошибки - сообщить релиз-менеджеру.
  Релиз-менеджеру же обратиться к zhur@

  3. Пакеты
  
  Проверяем id:
  Запускаем
  LOG_TEE=1 perl /opt/ppc-data/deploy-files/deploy/20131115_shard_maps.pl --check2
  Работает несколько минут. Если скрипт написал "OK", идем дальше. Если скрипт сообщил "FAIL": повторить запуск еще раз. 
  Если три запуска дают ошибки - сообщить релиз-менеджеру.
  Релиз-менеджеру же обратиться к zhur@

  4. Меняем offset'ы обратно:
  
  на мастере ppcdata1
  lm ppcdata1 sql 'set global auto_increment_increment = 1; set global auto_increment_offset = 1;'

  на мастере ppcdict
  lm ppcdict sql 'set global auto_increment_increment = 1; set global auto_increment_offset = 1;'

  на одном из ppcback
  direct-clus PERL apache-reload

Если придется откатывать полностью выложенный релиз: 
Установить разные оффсеты на ppc и ppcdict (п. 2), 
откатить пакеты, 
вернуть offset=1 для ppc и ppcdict (п.4)

Повторная выкладка: 
в целом все надо повторить, но точную инструкцию надо будет составлять с учетом возникших проблем и того, насколько полностью все выложили в первый раз. 
    !,
},
{
  type => 'sql',
  webstop => "0",
  db => "ppc",
  when => 'after',
  time_estimate => "3 секунды",
  comment => "выполнять, когда будет понятно, что релиз откатываться не будет",
  sql => "ALTER TABLE maps DROP INDEX `x`, ADD INDEX `xy` (`x`,`y`,`x1`,`y1`,`x2`,`y2`)",
},
]
=cut


use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use CheckShardMetabaseId;

use utf8;

$Yandex::DBShards::STRICT_SHARD_DBNAMES = 0;

my $INIT_INCREMENT = 0;
my $CHECK1 = 0;
my $CHECK2 = 0;

GetOptions("inc" => \$INIT_INCREMENT,
           "check1" => \$CHECK1,
           "check2" => \$CHECK2,
          );

my %tables = ('mid'            => 'maps',
             );


my $OFFSET = 300_000;

if ($INIT_INCREMENT) {
    $log->out('INIT START');

    my $max_maps_id = get_one_field_sql(PPC, "select max(mid)+$OFFSET from maps");
    $log->out("init inc_maps_id auto_increment with $max_maps_id");
    do_sql(PPCDICT, "replace into inc_maps_id values ($max_maps_id)");

    my $max_report_id = get_one_field_sql(PPC, "
                          select max(id)+$OFFSET
                            from (
                                select max(id) as id from pdf_reports
                                union all
                                select max(id) as id from bm_reports
                                union all
                                select max(id) as id from stat_reports
                                ) as t
                            ");
    $log->out("init inc_report_id auto_increment with $max_report_id");
    do_sql(PPCDICT, "replace into inc_report_id values (?)", $max_report_id);

    my $max_mcb_phrases_id = get_one_field_sql(PPC, "select max(id)+$OFFSET from mcb_phrases");
    $log->out("init inc_mcb_phrases_id auto_increment with $max_mcb_phrases_id");
    do_sql(PPCDICT, "replace into inc_mcb_phrases_id values (?)", $max_mcb_phrases_id);

    my $max_bmp_id = get_one_field_sql(PPC, "select max(imp_id)+$OFFSET from banner_images_pool");
    $log->out("init shard_inc_banner_images_pool_id auto_increment with $max_bmp_id");
    do_sql(PPCDICT, "replace into shard_inc_banner_images_pool_id values (?, ?)", $max_bmp_id, 0);

    my $max_impq_id = get_one_field_sql(PPC, "select max(imq_id)+$OFFSET from banner_images_process_queue");
    $log->out("init inc_banner_images_process_queue_id auto_increment with $max_impq_id");
    do_sql(PPCDICT, "replace into inc_banner_images_process_queue_id values (?)", $max_impq_id);

    my $max_notif_id = get_one_field_sql(PPC, "select max(notification_id)+$OFFSET from users_notifications");
    $log->out("init inc_users_notification_id auto_increment with $max_notif_id");
    do_sql(PPCDICT, "replace into inc_users_notification_id values (?)", $max_notif_id);

    $log->out("INIT FINISH");
    exit;
}
if ($CHECK1) {
    CheckShardMetabaseId::check(0, \%tables, $log);
    exit;
}
if ($CHECK2) {
    CheckShardMetabaseId::check(1, \%tables, $log);
    exit;
}

exit;
