#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => 'несколько минут (порядка 120_000 update-ов)',
  comment => 'Отправляем баннеры, которые числятся черновиками, но уже отправлялись в БК - на модерацию.
              Берем только те кампании, в которые загружались xls-файлы после выкатки кода который отправлял баннеры в черновики.',
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use Yandex::DateTime;
use Yandex::TimeCommon;
use Yandex::HashUtils;
use Yandex::Retry;

use BannersCommon;

use utf8;

$| = 1;

local $Yandex::DBShards::STRICT_SHARD_DBNAMES = 0;

my $BANNERS_LIMIT = 60_000;
extract_script_params(
    'limit=s' => \$BANNERS_LIMIT,
    );

$log->out('START');

my %cids = ();
# примерное время выкладки изменений, которые отправляли по ошибке баннеры в черновики
my $date_start = '2013-11-13 16:00:00';
# примерное время выкладки изменений, которые чинят ошибку
my $date_to    = '2013-11-15 18:00:00';

$log->out("date_start: $date_start, date_to: $date_to");

my ($log_date_start, $log_date_to) = map {/^(\S+)\s/ ? $1 : ()} ($date_start, $date_to);
foreach my $log_date (get_distinct_dates($log_date_start, $log_date_to)) {
    next unless is_table_exists(PPCLOG_HEAVY, "logcmd_$log_date");
    hash_merge \%cids, get_hash_sql(PPCLOG_HEAVY, ["select cid from logcmd_$log_date",
                                                             where => {cmd => 'importCampSuccess',
                                                                       logtime__ge => $date_start,
                                                                       logtime__le => $date_to}]);
}

my $banners = get_all_sql(PPC_HEAVY, ["select c.cid, 
                                             c.statusModerate as camp_statusModerate,
                                             b.bid,
                                             b.pid
                                        from campaigns c 
                                        join banners b using (cid)",
                                       where => {'c.cid' => [keys %cids],
                                                 'c.statusModerate__ne' => 'New',
                                                 'b.statusModerate' => 'New',
                                                 'b.BannerID__ne' => 0},
                                       limit => $BANNERS_LIMIT
                                    ]);
foreach my $banner (@$banners) {
    relaxed times => 1, sub {
        $log->out("processing cid=$banner->{cid}, pid=$banner->{pid}, bid=$banner->{bid}");
        update_banner_status_moderate(PPC, $banner->{bid}, $banner->{camp_statusModerate});
    };
}

$log->out('FINISH');

