#!/usr/bin/perl

use my_inc "..";


=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '2 минуты',
  comment => 'исправляем campaigns.statusActive="Yes" у кампаний без денег',
}

=cut

use strict;
use warnings;

use lib::abs '../protected';

use Settings;
use Yandex::DBTools;
use Yandex::DBShards;
use ScriptHelper;

use utf8;

$log->out('START');

my %cond = (
    statusActive => 'Yes',
    _TEXT => 'sum - sum_spent < 0.00001',
    type => 'text',
    statusEmpty => 'No',
);
my $cids = get_one_column_sql(PPC_HEAVY(shard => 'all'), ['SELECT cid FROM campaigns', WHERE => \%cond]) || [];
$log->out('Got ' . scalar(@$cids) . ' campaigns to fix:', $cids);

$log->out('Fixing');
my $fixed_cnt = 0;
for my $chunk (sharded_chunks cid => $cids, 1_000) {
    my $shard = $chunk->{shard};
    my $cids = $chunk->{cid};
    $fixed_cnt += do_update_table(PPC(shard => $shard), 'campaigns', {statusActive => 'No'}, where => \%cond);
}
$log->out("Done. Fixed $fixed_cnt campaigns");

$log->out('FINISH');
