#!/usr/bin/perl

use my_inc "..";


=head1 DEPLOY

# approved by zhur
# .migr
[
  {
      type => "sql",
      webstop => "0",
      db => "ppc",
      when => "before",
      time_estimate => "1 sec",
      sql => "CREATE TABLE `clients_options` (
        `ClientID` int(10) unsigned NOT NULL,
        `balance_tid` bigint(20) unsigned NOT NULL,
        `overdraft_lim` decimal(10,2) NOT NULL,
        `debt` decimal(10,2) NOT NULL,
        `nextPayDate` date NOT NULL,
        `statusBalanceBanned` enum('Yes','No') DEFAULT 'No',
        `warned_nextPayDate` date DEFAULT NULL,
        `warned_interval` tinyint(4) DEFAULT NULL,
        `discount` decimal(4,2) DEFAULT NULL,
        `budget` decimal(10,2) DEFAULT NULL,
        `border_next` decimal(10,2) DEFAULT NULL,
        `discount_next` decimal(4,2) DEFAULT NULL,
        `border_prev` decimal(10,2) DEFAULT NULL,
        PRIMARY KEY (`ClientID`)
      ) ENGINE=InnoDB DEFAULT CHARSET=utf8"
  },
  {
      type => 'script',
      when => 'after',
      time_estimate => "2 min",
      comment => "привозит из overdraft актуальные данные, проходящие через NotifyClient, в clients_options"
  },
]
=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use Yandex::DBShards;
use ScriptHelper;

use utf8;

$log->out('START');

my $overdrafts = get_hashes_hash_sql(PPCDICT, 'select
                                                  ClientID, balance_tid, overdraft_lim, debt, nextPayDate, statusBalanceBanned
                                               from overdraft where balance_tid > 0') || {};

my @chunks = sharded_chunks(ClientID => [keys %$overdrafts], 1_000);

foreach my $chunk (@chunks) {
    my $client_ids = $chunk->{ClientID};
    my $shard = $chunk->{shard};

    my @data;

    foreach my $client_id (@$client_ids) {
        my $vals = [map { $overdrafts->{$client_id}->{$_} } qw/ClientID balance_tid overdraft_lim debt nextPayDate statusBalanceBanned/];

        push @data, $vals;
    }

    do_mass_insert_sql(PPC(shard => $shard), qq{ insert into clients_options (
                            ClientID
                            , balance_tid
                            , overdraft_lim
                            , debt
                            , nextPayDate
                            , statusBalanceBanned
                        )
                        values %s
                        on duplicate key update
                            overdraft_lim = if(values(balance_tid) > balance_tid, values(overdraft_lim), overdraft_lim),
                            debt          = if(values(balance_tid) > balance_tid, values(debt), debt),
                            nextPayDate   = if(values(balance_tid) > balance_tid, values(nextPayDate), nextPayDate),
                            statusBalanceBanned = if(values(balance_tid) > balance_tid, values(statusBalanceBanned), statusBalanceBanned),
                            balance_tid   = if(values(balance_tid) > balance_tid, values(balance_tid), balance_tid)
                      }, \@data
  );
}

$log->out('FINISH');
